/* net.c
 *
 * This file is part of httpd.
 *
 * 01/25/96 			Michael Temari, <temari@ix.netcom.com>
 * 07/07/96 Initial Release	Michael Temari, <temari@ix.netcom.com>
 *
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <net/netlib.h>
#include <net/hton.h>
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/tcp.h>
#include <net/gen/tcp_io.h>
#include <net/gen/socket.h>
#include <net/gen/netdb.h>

#include "net.h"

ipaddr_t myipaddr, rmtipaddr;
tcpport_t myport, rmtport;
char myhostname[256];
char rmthostname[256];

void GetNetInfo()
{
nwio_tcpconf_t tcpconf;
int s;
struct hostent *hostent;

   /* Ask the system what our hostname is. */
   if(gethostname(myhostname, sizeof(myhostname)) < 0)
	strcpy(myhostname, "unknown");

   /* lets get our ip address and the clients ip address */
   s = ioctl(0, NWIOGTCPCONF, &tcpconf);
   if(s < 0) {
   	myipaddr = 0;
   	myport = 0;
   	rmtipaddr = 0;
   	rmtport = 0;
   	strcpy(rmthostname, "??Unknown??");
   	return;
   }

   myipaddr = tcpconf.nwtc_locaddr;
   myport = tcpconf.nwtc_locport;
   rmtipaddr = tcpconf.nwtc_remaddr;
   rmtport = tcpconf.nwtc_remport;

   /* Look up the host name of the remote host. */
   hostent = gethostbyaddr((char *) &rmtipaddr, sizeof(rmtipaddr), AF_INET);
   if(!hostent)
	strncpy(rmthostname, inet_ntoa(rmtipaddr), sizeof(rmthostname)-1);
   else
	strncpy(rmthostname, hostent->h_name, sizeof(rmthostname)-1);

   rmthostname[sizeof(rmthostname)-1] = '\0';

   return;
}
