/* reply.c
 *
 * This file is part of httpd.
 *
 * 02/17/96 			Michael Temari, <temari@ix.netcom.com>
 * 07/07/96 Initial Release	Michael Temari, <temari@ix.netcom.com>
 *
 */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include "http.h"
#include "utility.h"
#include "net.h"
#include "config.h"

#define	SERVER	"Server: Minix httpd 0.92 by Michael Temari"

_PROTOTYPE(static int sendout, (char *data));

static int sendout(data)
char *data;
{
   if(strlen(data) > 0)
	write(1, data, strlen(data));
   write(1, "\r\n", 2);
   if(dbglog != (FILE *)NULL) {
	fprintf(dbglog, "REPLY: %s\n", data);
	fflush(dbglog);
   }

   return(0);
}

int sendreply(rp, rq)
struct http_reply *rp;
struct http_request *rq;
{
int s;
static char buffer[8192];

   if(rq->method == HTTP_METHOD_POST) {
   	if(rq->type != HTTP_REQUEST_TYPE_FULL)
   		return(0);
   	rp->status = HTTP_STATUS_CREATED;
   	while(rq->size > 0) {
   		s = read(0, buffer, (rq->size > sizeof(buffer)) ? sizeof(buffer) : rq->size);
   		if(s <= 0) {
   			rp->status = HTTP_STATUS_SERVER_ERROR;
   			strcpy(rp->statusmsg, strerror(errno));
   			close(rp->fd);
   			close(rp->ofd);
   			break;
   		}
   		rq->size -= s;
   		write(rp->ofd, buffer, s);
   	}
   }

   if(rq->method == HTTP_METHOD_PUT && rp->status == HTTP_STATUS_OK) {
   	if(rq->type != HTTP_REQUEST_TYPE_FULL)
   		return(0);
   	rp->status = HTTP_STATUS_OK;
   	while(rq->size > 0) {
   		s = read(0, buffer, (rq->size > sizeof(buffer)) ? sizeof(buffer) : rq->size);
   		if(s <= 0) {
   			rp->status = HTTP_STATUS_SERVER_ERROR;
   			strcpy(rp->statusmsg, strerror(errno));
   			close(rp->fd);
   			close(rp->ofd);
   			break;
   		}
   		rq->size -= s;
   		write(rp->ofd, buffer, s);
   	}
   }

   if(rq->type == HTTP_REQUEST_TYPE_FULL) {
	sprintf(buffer, "HTTP/1.0 %03d %s", rp->status, rp->statusmsg);
	sendout(buffer);
	sendout(SERVER);
	if(rp->status == HTTP_STATUS_MOVED_PERM ||
	   rp->status == HTTP_STATUS_MOVED_TEMP) {
	   	sprintf(buffer, "Location: http://%s%s", myhostname, rq->url);
	   	sendout(buffer);
	}
	if(rp->keepopen)
		sendout("Connection: Keep-Alive");
	if(rp->status == HTTP_STATUS_UNAUTHORIZED && rp->auth != NULL) {
		sprintf(buffer, "WWW-Authenticate: Basic realm=\"%s\"", rp->auth->desc);
		sendout(buffer);
	}
	if(rp->status == HTTP_STATUS_OK) {
		if(rp->modtime != (time_t) -1) {
			sprintf(buffer, "Last-Modified: %s", httpdate(&rp->modtime));
			sendout(buffer);
		}
		if(rp->size != -1) {
			sprintf(buffer, "Content-Length: %ld", rp->size);
			sendout(buffer);
		}
		sprintf(buffer, "Content-Type: %s", rp->mtype);
		sendout(buffer);
	} else
		sendout("Content-Type: text/html");
	sendout("");
   } else
	if(rp->status != HTTP_STATUS_OK)
		return(0);

   if(rp->status != HTTP_STATUS_OK && rp->status != HTTP_STATUS_CREATED) {
	rq->keepopen = 0;
	sprintf(buffer, "<h2>Error %03d %s</h2>",
		rp->status, rp->statusmsg);
	sendout(buffer);
	return(0);
   }

   /* send out entity body */
   if(rq->method == HTTP_METHOD_GET || rq->method == HTTP_METHOD_POST)
	while((s = read(rp->fd, buffer, sizeof(buffer))) > 0)
		write(1, buffer, s);

   close(rp->fd);
   if(rp->ofd != -1)
	close(rp->ofd);

   return(0);
}
