/* request.c
 *
 * This file is part of httpd.
 *
 * 02/17/96 			Michael Temari, <temari@ix.netcom.com>
 * 07/07/96 Initial Release	Michael Temari, <temari@ix.netcom.com>
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>
#include <pwd.h>
#ifdef _MINIX
#include <minix/minlib.h>
#endif
#include <errno.h>

#include "http.h"
#include "utility.h"
#include "config.h"

_PROTOTYPE(static void Timeout, (int sig));
_PROTOTYPE(static int getline, (char *buffer, int size));
_PROTOTYPE(static void authorize, (char *p, struct http_request *rq));
_PROTOTYPE(static char decurl, (char **p));

static int TimeOut;

static void Timeout(sig)
int sig;
{
   TimeOut = 1;
}

static int getline(buffer, size)
char *buffer;
int size;
{
char *p;
int s;

   p = buffer;

   while(p < (buffer + size - 1)) {
   	TimeOut = 0;
   	signal(SIGALRM, Timeout);
   	alarm(5*60);
	s = read(0, p, 1);
	alarm(0);
	if(TimeOut)
		return(-1);
	if(s != 1)
		return(-1);
	if(*p == '\n') break;
	p++;
   }
   *++p = '\0';

   if(strlen(buffer) > 0) {
	p = &buffer[strlen(buffer) - 1];
	if(*p == '\r' || *p == '\n') *p-- ='\0';
	if(*p == '\r' || *p == '\n') *p-- ='\0';
   }

   return(strlen(buffer));
}

static void authorize(p, rq)
char *p;
struct http_request *rq;
{
char *s;

   if(toupper(*p++) == 'B' &&
      toupper(*p++) == 'A' &&
      toupper(*p++) == 'S' &&
      toupper(*p++) == 'I' &&
      toupper(*p++) == 'C' &&
      toupper(*p++) == ' ') ;
   else
   	return;

   s = decode64(p);

   if((p = strchr(s, ':')) == (char *)NULL)
   	p = "";
   else
   	*p++ = '\0';

   strncpy(rq->authuser, s, sizeof(rq->authuser));
   strncpy(rq->authpass, p, sizeof(rq->authpass));

   return;
}

int getrequest(rq)
struct http_request *rq;
{
static char line[4096];
char *p, *p2;
int s, len;

   /* get request, it may be simple */

   s = getline(line, sizeof(line));
   if(s < 0)
	return(-1);

   if(dbglog != (FILE *)NULL) {
	fprintf(dbglog, "REQUEST: %s\n", line);
	fflush(dbglog);
   }

   /* clear http_request */
   memset(rq, 0, sizeof(*rq));
   rq->ifmodsince = (time_t) -1;

   /* assume simple request */
   rq->type = HTTP_REQUEST_TYPE_SIMPLE;

   /* parse the method */
   p = line;
   while(*p && !LWS(*p)) {
   	*p = toupper(*p);
   	p++;
   }
   if(*p) *p++ = '\0';
   if(!strcmp(line, "GET"))
	rq->method = HTTP_METHOD_GET; else
   if(!strcmp(line, "HEAD"))
	rq->method = HTTP_METHOD_HEAD; else
   if(!strcmp(line, "POST"))
	rq->method = HTTP_METHOD_POST; else
   if(!strcmp(line, "PUT"))
	rq->method = HTTP_METHOD_PUT; else
#if 0
   if(!strcmp(line, "OPTIONS"))
	rq->method = HTTP_METHOD_OPTIONS; else
   if(!strcmp(line, "PATCH"))
	rq->method = HTTP_METHOD_PATCH; else
   if(!strcmp(line, "COPY"))
	rq->method = HTTP_METHOD_COPY; else
   if(!strcmp(line, "MOVE"))
	rq->method = HTTP_METHOD_MOVE; else
   if(!strcmp(line, "DELETE"))
	rq->method = HTTP_METHOD_DELETE; else
   if(!strcmp(line, "LINK"))
	rq->method = HTTP_METHOD_LINK; else
   if(!strcmp(line, "UNLINK"))
	rq->method = HTTP_METHOD_UNLINK; else
   if(!strcmp(line, "TRACE"))
	rq->method = HTTP_METHOD_TRACE; else
   if(!strcmp(line, "WRAPPED"))
	rq->method = HTTP_METHOD_WRAPPED; else
#endif
	rq->method = HTTP_METHOD_UNKNOWN;

   /* parse the requested URL */
   p2 = rq->url;
   len = sizeof(rq->url) - 1;
   while(*p && !LWS(*p) && *p != '?' && len > 0) {
   	*p2++ = decurl(&p);
	len--;
   }
   *p2 = '\0';

   /* See if there is a query string */
   if(*p == '?') {
   	p++;
   	p2 = rq->query;
   	len = sizeof(rq->query) - 1;
   	while(*p && !LWS(*p) && len > 0) {
   		*p2++ = *p++;
		len--;
	}
   }

   /* eat up any leftovers */
   while(*p && !LWS(*p)) p++;

   if(rq->url[0] == '\0')
   	strcpy(rq->url, "/");
   if(rq->url[0] != '/')
   	strcpy(rq->url, "/");

   /* if this is true it is a simple request */
   if(!*p)
	return(0);

   /* parse HTTP version */
   while(*p && LWS(*p)) p++;
   if(toupper(*p) != 'H') return(0);
   p++;
   if(toupper(*p) != 'T') return(0);
   p++;
   if(toupper(*p) != 'T') return(0);
   p++;
   if(toupper(*p) != 'P') return(0);
   p++;
   if(*p != '/') return(0);
   p++;
   rq->vmajor = 0;
   while((*p >= '0') && (*p <= '9'))
	rq->vmajor = rq->vmajor * 10 + (*p++ - '0');
   if(*p != '.') return(0);
   p++;
   rq->vminor = 0;
   while((*p >= '0') && (*p <= '9'))
	rq->vminor = rq->vminor * 10 + (*p++ - '0');
   if(*p) return(0);

   rq->type = HTTP_REQUEST_TYPE_FULL;

   /* parse any header fields */
   while((s = getline(line, sizeof(line))) > 0) {
   	if(toupper(line[0]) == 'A' &&
   	   toupper(line[1]) == 'U')
		if(dbglog != (FILE *)NULL) {
			fprintf(dbglog, "REQUEST: Authorization:\n");
			fflush(dbglog);
		} else ;
	else
		if(dbglog != (FILE *)NULL) {
			fprintf(dbglog, "REQUEST: %s\n", line);
			fflush(dbglog);
		}
	p = line;
	while(*p && *p != ':') {
		*p = toupper(*p);
		p++;
	}
	if(*p != ':') continue;		/* bad header field, skip it */
	*p++ = '\0';
	while(*p && LWS(*p)) p++;

	/* header field value parsing here */
	if(!strcmp(line, "CONNECTION"))
		rq->keepopen = 1; else
	if(!strcmp(line, "IF-MODIFIED-SINCE"))
		rq->ifmodsince = httptime(p); else
	if(!strcmp(line, "CONTENT-LENGTH"))
		rq->size = atol(p); else
	if(!strcmp(line, "AUTHORIZATION"))
		authorize(p, rq); else
	if(!strcmp(line, "DATE"))
		rq->msgdate = httptime(p);
   }

   if(s < 0) {
	fprintf(stderr, "httpd: getrequest: Error getline (header fields)\n");
	return(-1);
   }

   return(0);
}

static char decurl(p)
char **p;
{
char *p2;
char h1, h2;
char c;

   p2 = *p;
   switch(*p2) {
   	case '\0':
   		c = '\0';
   		break;
   	case '+':
   		c = ' ';
   		p2++;
   		break;
   	case '%':
		h1 = '0';
		h2 = '0';
		p2++;
		h1 = tolower(*p2);
		if(*p2) p2++;
		h2 = tolower(*p2);
		if(*p2) p2++;
		c = (h1 > '9') ? (10 + h1 - 'a') : (h1 - '0');
		c = 16 * c + ((h2 > '9') ? (10 + h2 - 'a') : (h2 - '0'));
		break;
	default:
		c = *p2++;
   }

   *p = p2;

   return(c);
}
