/* httpget.c
 *
 * httpget	A client using the HTTP protocol to get a document
 *		from a web server and to send it out stdout.
 *
 * Usage:	httpget host file
 *
* 08/08/96 1.00		Michael Temari, <temari@ix.netcom.com>
 *
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>
#include <net/netlib.h>
#include <net/hton.h>
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/tcp.h>
#include <net/gen/tcp_io.h>
#include <net/gen/socket.h>
#include <net/gen/netdb.h>

_PROTOTYPE(int connect, (char *host));
_PROTOTYPE(int main, (int argc, char *argv[]));

int connect(host)
char *host;
{
nwio_tcpconf_t tcpconf;
nwio_tcpcl_t tcpcopt;
char *tcp_device;
int netfd;
ipaddr_t nethost;
tcpport_t netport;
struct hostent *hp;
struct servent *sp;
int s;
int tries;

   if((hp = gethostbyname(host)) == (struct hostent *)NULL) {
	fprintf(stderr, "Unknown host %s!\n", host);  
	return(-1);
   } else
	memcpy((char *) &nethost, (char *) hp->h_addr, hp->h_length);

   /* Now, to which port must we connect? */
   if((sp = getservbyname("http", "tcp")) == (struct servent *)NULL) {
	fprintf(stderr, "HTTP port is unknown????\n");
	return(-1);
   } else
	netport = sp->s_port;

   /* Connect to the host */
   if((tcp_device = getenv("TCP_DEVICE")) == NULL)
	tcp_device = TCP_DEVICE;

   if((netfd = open(tcp_device, O_RDWR)) < 0) {
	perror("netdate: opening tcp");
	return(-1);
   }

   tcpconf.nwtc_flags = NWTC_LP_SEL | NWTC_SET_RA | NWTC_SET_RP;
   tcpconf.nwtc_remaddr = nethost;
   tcpconf.nwtc_remport = netport;

   s = ioctl(netfd, NWIOSTCPCONF, &tcpconf);
   if(s < 0) {
	perror("netdate: NWIOSTCPCONF");
	close(netfd);
	return(-1);
   }

   s = ioctl(netfd, NWIOGTCPCONF, &tcpconf);
   if(s < 0) {
	perror("netdate: NWIOGTCPCONF");
	close(netfd);
	return(-1);
   }

   tcpcopt.nwtcl_flags = 0;

   tries = 0;
   do {
	s = ioctl(netfd, NWIOTCPCONN, &tcpcopt);
	if(s == -1 && errno == EAGAIN) {
		if(tries++ >= 10)
			break;
		sleep(1);
	} else
		break;
   } while(1);

   if(s < 0) {
	perror("netdate: NWIOTCPCONN");
	close(netfd);
	return(-1);
   }

   return(netfd);
}

char buffer[16000];

int main(argc, argv)
int argc;
char *argv[];
{
int fd;
int s;

   if(argc != 3) {
	fprintf(stderr, "Usage: httpget host file\n");
	return(-1);
   }

   fd = connect(argv[1]);
   if(fd < 0) return(-1);

   write(fd, "GET ", 4);
   write(fd, argv[2], strlen(argv[2]));
   write(fd, "\r\n", 2);

   while((s = read(fd, buffer, sizeof(buffer))) > 0)
	if(write(1, buffer, s) != s) {
		perror("write");
		return(-1);
	}
   if(s < 0) {
	perror("read:");
	return(-1);
   }
   return(0);
}
