/*
 * $Id: symlib.h,v 1.1 1996/03/20 21:39:02 paul Exp $
 *
 * based on @(#)symlib.h 1.1 91/05/08 Paul Ashton
 *
 * Include file for the symbol table library functions.
 */

struct symbol_table;

typedef struct symbol_table *symptr;

typedef void (*tidyfunc)(void *user_data);

symptr sym_create_table(void);      /* returns: pointer to new symbol table. */

int sym_add(symptr sym_table, char *sym_name, void *user_info);
                                    /* returns: 0 if OK, -1 and sym_errno */
				    /*     set on error (already exists; */
				    /*     illegal name).  */

void *sym_find(symptr sym_table, char *sym_name);
				    /* returns: ptr to user info, */
				    /*     NULL and sym_errno set if error */
				    /*     (nof found; illegal name) */
                                    /* NOTE: NULL is a valid value for the */
                                    /* user info ptr - so if NULL is */
                                    /* returned and sym_errno is SERR_OK, */
                                    /* then the symbol was found, but its */
                                    /* user info ptr was NULL */

void *sym_change_data(symptr sym_table, char *sym_name, void *user_info);
                                    /* returns: previous user info if OK, */
                                    /*     NULL and sym_errno set on error */
				    /*     (not found; illegal name) */


int sym_delete(symptr sym_table, char *sym_name, tidyfunc tidyup);
				    /* returns: 0 if OK, */
				    /*     -1 and sym_errno set if error */
				    /*     (not found; illegal name) */

void sym_setup_traverse(symptr sym_table);

void *sym_next(symptr sym_table, char **sym_name);
                                    /* returns: ptr to user info if OK, */
                                    /*     NULL and sym_errno set if error */
                                    /*     (no more symbols; symbol not set) */
                                    /* NOTE: NULL is a valid value for the */
                                    /* user info ptr - so if NULL is */
                                    /* returned and sym_errno is SERR_OK, */
                                    /* then the symbol was found, but its */
                                    /* user info ptr was NULL */


void sym_delete_table(symptr sym_table, tidyfunc tidyup);

extern int sym_errno;

#define SERR_OK                 0   /* no error */
#define SERR_ALREADY_DEFINED    1   /* symbol already defined */
#define SERR_NOT_FOUND          2   /* symbol not found */
#define SERR_ILLEGAL_NAME       3   /* name contains illegal char or has */
                                    /*      length 0 */
#define SERR_NO_MORE_SYMS       4   /* traverse has run out of symbols */
