#include <sys/types.h>
#include <netinet/in.h>
#include "lib.h"

u_int atohost(const char *cp)
{
    u_int host;

    memcpy(&host, cp, sizeof(host));
    return ntohl(host);
}


u_short atoport(const char *cp)
{
    u_short port;

    memcpy(&port, cp, sizeof(port));
    return ntohs(port);
}


void hosttoa(char *cp, u_int host)
{
    host = htonl(host);
    memcpy(cp, &host, sizeof(host));
}


void porttoa(char *cp, u_short port)
{
    port = htons(port);
    memcpy(cp, &port, sizeof(port));
}
