static char *rcsid = "$Id: next_prog_addr.c,v 1.1 1996/06/04 08:29:55 paul Exp $";

/*
 * This program is used in conjunction with the make_map_file script
 * to generate the map files used in linking of mm and fs.
 * It prints the ending virtual address of the end of the address space 
 * of the smx executable on the standard input.
 */
#include <stdio.h>
#include <unistd.h>

#include "../../include/minix/config.h"
#undef NULL /* Defined again in const.h */
#include "../../include/minix/const.h"
#include "../../include/ansi.h"
#include "../../include/a.out.h"


static char *progname;

/*
 * Local functions
 */
static void usage(void);

/*
 * Function: main
 * Parameters: argc, argv - no command line arguments
 *
 * Reads the header, validates it, then prints out the virtual address of the
 * first byte that follows this address space (which should be click
 * aligned).  In other words, prints the address at which the program
 * to follow this one should be loaded.
 */
int main(int argc, char *argv[])
{
    struct exec mxhead;

    progname = argv[0];
    if (argc != 1) usage();

    if (read(0, &mxhead, sizeof(mxhead)) != sizeof(mxhead)) {
	return 1;
    }

    if (BADMAG(mxhead) || mxhead.a_hdrlen != sizeof(mxhead) ||
	mxhead.a_cpu != A_SUNOS || (mxhead.a_flags & A_SEP) == 0 ||
	mxhead.a_total == 0 || mxhead.a_text % CLICK_SIZE != 0 ||
	mxhead.a_total < mxhead.a_data + mxhead.a_bss) {
	return 0;
    }
    
    printf("0x%lx\n", mxhead.a_tbase + mxhead.a_text + 
	   upclick(mxhead.a_total));
    return 0;
}


/*
 * Function: usage
 */
static void usage(void)
{
    fprintf(stderr, "Usage: %s\n", progname);
}
