#!/bin/sh
#
# DESCRIBE 1.16 - Describe the given devices.		Author: Kees J. Bot
#
# BUGS
# - Arguments may not contain shell metacharacters.

case $# in
0)	flag=; set -$- /dev ;;
*)	flag=d ;;
esac

ls -l$flag $* | \
sed	-e '/^total/d' \
	-e '/^[^bc]/s/.* /BAD BAD /' \
	-e '/^[bc]/s/.* \([0-9][0-9]*\), *\([0-9][0-9]*\).* /\1 \2 /' \
| {
ex=0	# exit code

while read major minor path
do
	case $path in
	/*)	name=`expr $path : '.*/\\(.*\\)$'`
		;;
	*)	name=$path
	esac

	case $major,$minor in
	1,0)	des="RAM disk" dev=ram
		;;
	1,1)	des="memory" dev=mem
		;;
	1,2)	des="kernel memory" dev=kmem
		;;
	1,3)	des="null device, data sink" dev=null
		;;
	2,*)    des="smx filesystem $minor" dev=hdx$minor
		;;
	3,[05]|3,[123][05])
		drive=`expr $minor / 5`
		des="hard disk drive $drive" dev=hd$minor
		;;
	3,?|3,[123]?)
		drive=`expr $minor / 5`
		par=`expr $minor % 5`
		des="hard disk $drive, partition $par" dev=hd$minor
		;;
	3,12[89]|3,1[3-9]?|3,2??)
		drive=`expr \\( $minor - 128 \\) / 16`
		par=`expr \\( \\( $minor - 128 \\) / 4 \\) % 4 + 1`
		sub=`expr \\( $minor - 128 \\) % 4 + 1`
		des="hard disk $drive, partition $par, subpartition $sub"
		par=`expr $drive '*' 5 + $par`
		case $sub in
		1)	dev=hd${par}a ;;
		2)	dev=hd${par}b ;;
		3)	dev=hd${par}c ;;
		4)	dev=hd${par}d ;;
		esac
		;;
	4,0)	des="console device" dev=console
		;;
	4,[1-3])des="virtual console $minor" dev=ttyc$minor
		;;
	4,15)	des="diagnostics device" dev=log
		;;
	4,1[6-9])
		line=`expr $minor - 16`
		des="serial line $line" dev=tty0$line
		;;
	4,12[89]|4,1[3-8]?|4,19[01])
		p=`expr \\( $minor - 128 \\) / 16 | tr '0123' 'pqrs'`
		n=`expr $minor % 16`
		test $n -ge 10 && n=`expr $n - 10 | tr '012345' 'abcdef'`
		des="pseudo tty `expr $minor - 128`" dev=tty$p$n
		;;
	4,???)
		p=`expr \\( $minor - 192 \\) / 16 | tr '0123' 'pqrs'`
		n=`expr $minor % 16`
		test $n -ge 10 && n=`expr $n - 10 | tr '012345' 'abcdef'`
		des="controller of tty$p$n" dev=pty$p$n
		;;
	5,0)	des="anonymous tty" dev=tty
		;;
	6,0)	des="line printer, parallel port" dev=lp
		;;
	7,1)	des="raw ethernet" dev=eth
		;;
	7,2)	des="raw IP" dev=ip
		;;
	7,3)	des="TCP/IP" dev=tcp
		;;
	7,4)	des="UDP" dev=udp
		;;
	8,0)	des="CD-ROM" dev=cd0
		;;
	8,[1-4])
		des="CD-ROM, partition $minor" dev=cd$minor
		;;
	8,12[89]|8,13?|8,14[0-3])
		par=`expr \\( $minor - 128 \\) / 4 + 1`
		sub=`expr \\( $minor - 128 \\) % 4 + 1`
		des="CD-ROM, partition $par, subpartition $sub"
		case $sub in
		1)	dev=cd${par}a ;;
		2)	dev=cd${par}b ;;
		3)	dev=cd${par}c ;;
		4)	dev=cd${par}d ;;
		esac
		;;
	10,[05]|10,[123][05])
		drive=`expr $minor / 5`
		des="scsi disk drive $drive" dev=sd$minor
		;;
	10,?|10,[123]?)
		drive=`expr $minor / 5`
		par=`expr $minor % 5`
		des="scsi disk $drive, partition $par" dev=sd$minor
		;;
	10,12[89]|10,1[3-9]?|10,2??)
		drive=`expr \\( $minor - 128 \\) / 16`
		par=`expr \\( \\( $minor - 128 \\) / 4 \\) % 4 + 1`
		sub=`expr \\( $minor - 128 \\) % 4 + 1`
		des="scsi disk $drive, partition $par, subpartition $sub"
		par=`expr $drive '*' 5 + $par`
		case $sub in
		1)	dev=sd${par}a ;;
		2)	dev=sd${par}b ;;
		3)	dev=sd${par}c ;;
		4)	dev=sd${par}d ;;
		esac
		;;
	10,6[4-9]|10,7?)
		tape=`expr \\( $minor - 64 \\) / 2`
		case $minor in
		*[02468])
			des="scsi tape $tape (non-rewinding)" dev=nrst$tape
			;;
		*[13579])
			des="scsi tape $tape (rewinding)" dev=rst$tape
		esac
		;;
	13,0)
		des="audio" dev=audio
		;;
	14,0)
		des="audio mixer" dev=mixer
		;;
	BAD,BAD)
		des= dev=
		;;
	*)	dev=BAD
	esac

	case $name:$dev in
	*:)
		echo "$path: not a device" >&2
		ex=1
		;;
	*:*BAD*)
		echo "$path: cannot describe: major=$major, minor=$minor" >&2
		ex=1
		;;
	$dev:*)
		echo "$path: $des"
		;;
	*:*)	echo "$path: nonstandard name for $dev: $des"
	esac
done

exit $ex
}
