#!/bin/sh
# With no arguments, everything is loaded.  Otherwise only the 
# specified cases are handled.
#
# This script should be used to load new executables into /bin and
# /usr/bin.  While you could use sunload directly, this script
# looks after permissions (including setuid), owner, group, and 
# multiple hard links to the same file.  Some files are present in /bin and
# /usr/bin---this script also takes care of that.  If you want to load into
# /bin and /usr/bin then run this script from /.  If you are creating 
# new bin and usr/bin directories lower in the hieararchy then
# run this script from the directory that contains /bin and /usr/bin.


# Must be set to the full SunOS pathname of the commands dir.
sunosdir=/users/cosc/staff/paul/minix/1.7/minix1.7/src/commands

# Note that the A's in the following are just delimiters to preserve
# spaces---if you want to use A as a command name, choose another delimiter

# simpleusrbin---executables from src/commands/simple that are in /usr/bin
# only.
simpleusrbin="A add_route animals ascii at atrun banner basename btoa cal \
              calendar cdiff cgrep chmem ci cksum clr cmp co comm crc cron \
              cut dd decomp16 dhrystone diff dirname diskusage du dw ed \
              expand factor fgrep file find finger fold fortune fsck1 \
              gather getty gomoku grep head host hostaddr id ifconfig ifdef \
              in.fingerd in.rld in.rshd inodes install join last leave \
              life look lpr mail man men mesg mkfifo mkfs mknod mkproto \
              modem mref mt ncheck nonamed od paste pathchk ping pr \
              pr_routes prep pretty printenv proto ps rcp readall readfs \
              recover remsync rev rlogin rmdir roff rsh sed shar size sleep \
              sort split strings strip stty su sum swapfs synctree tail tar \
              tcpd tee term termcap tget time touch tr traverse treecmp tsort \
              ttt tty unexpand uniq unshar update vol wc whatsnew which \
              who whoami width write xargs yes A"

# simplebin---executables from src/commands/simple that are in /usr/bin
# and /bin.
simplebin="A cat chmod date df echo expr fsck isoread kill login ls \
          mkdir mount printroot pwd sync umount A"

# All the special cases
other="aal advent ash awk backup byacc cawf chown compress cp de elle elvis \
       ftp ic in.ftpd in.telnetd m4 make mined passwd patch pwdauth reboot  \
       scripts sh sun4 tcsh telnet test uemacs uname uud uue yap"

case $# in
  0)
    bins="$simpleusrbin $simplebin $other"
    ;;

  *)
    bins="$*"
    ;;
esac

for binfile in $bins
do
echo $binfile
    if echo $simpleusrbin | fgrep -s " $binfile "; then
        usrbinname=usr/bin/$binfile
	sunread $sunosdir/simple/bin/$binfile >$usrbinname
	case $binfile in
	  "at" | "hostaddr" | "install" | "mail" | "ping" | "recover" | "su")
		chown root:bin $usrbinname
		chmod 4755 $usrbinname
		;;
	  
	  "lpr")
		chown daemon:bin $usrbinname
		chmod 4755 $usrbinname
		;;

	  "ps")
		chown bin:kmem $usrbinname
		chmod 2755 $usrbinname
		;;

	  "term")
		chown bin:uucp $usrbinname
		chmod 2755 $usrbinname
		;;

	  "write")
		   chown bin:tty $usrbinname
		   chmod 2755 $usrbinname
		   ;;
	  
	  *) chown bin:bin $usrbinname
	     chmod 755 $usrbinname
	     ;;
	esac
    elif echo $simplebin | fgrep -s " $binfile "; then
        usrbinname=usr/bin/$binfile
        binname=bin/$binfile
	sunread $sunosdir/simple/bin/$binfile >$usrbinname
	cp $usrbinname $binname
	case $binfile in
	  "df" | "mount" | "umount")
		chown root:bin $usrbinname
		chmod 4755 $usrbinname
		chown root:bin $binname
		chmod 4755 $binname
		;;
	  

	  *)
	     chown bin:bin $usrbinname
	     chmod 755 $usrbinname
	     chown bin:bin $binname
	     chmod 755 $binname
	     ;;
	esac
    else
        case $binfile in
	  "A")
	    ;;

	  "aal")
	    sunread $sunosdir/aal/aal >usr/bin/aal
	    chown bin:bin usr/bin/aal
	    chmod 755 usr/bin/aal
	    rm -f usr/bin/ar
	    ln usr/bin/aal usr/bin/ar
	    ;;

	  "advent")
	    rm -rf usr/lib/advent
	    mkdir usr/lib/advent
	    chown bin:bin usr/lib/advent
	    chmod 755 usr/lib/advent
	    sunread $sunosdir/advent/advent1.dat >usr/lib/advent/advent1.dat
	    sunread $sunosdir/advent/advent2.dat >usr/lib/advent/advent2.dat
	    sunread $sunosdir/advent/advent3.dat >usr/lib/advent/advent3.dat
	    sunread $sunosdir/advent/advent4.dat >usr/lib/advent/advent4.dat
	    chown bin:bin usr/lib/advent/*
	    chmod 644 usr/lib/advent/*

	    sunread $sunosdir/advent/advent >usr/bin/advent
	    chown bin:bin usr/bin/advent
	    chmod 755 usr/bin/advent
	    ;;

	  "ash")
	    sunread $sunosdir/ash/ash >usr/bin/ash
	    chown bin:bin usr/bin/ash
	    chmod 755 usr/bin/ash
	    ;;

	  "awk")
	    sunread $sunosdir/awk/awk >usr/bin/awk
	    chown bin:bin usr/bin/awk
	    chmod 755 usr/bin/awk
	    ;;

	  "backup")
	    sunread $sunosdir/simple/bin/backup >usr/bin/backup
	    chown bin:bin usr/bin/backup
	    chmod 755 usr/bin/backup
	    rm -f usr/bin/restore
	    ln usr/bin/backup usr/bin/restore
	    ;;

	  "byacc")
	    sunread $sunosdir/byacc/yacc >usr/bin/yacc
	    chown bin:bin usr/bin/yacc
	    chmod 755 usr/bin/yacc
	    ;;

	  "cawf")
	    sunread $sunosdir/cawf/bsfilt >usr/bin/bsfilt
	    chown bin:bin usr/bin/bsfilt
	    chmod 755 usr/bin/bsfilt
	    rm -f usr/bin/colcrt
	    ln usr/bin/bsfilt usr/bin/colcrt

	    sunread $sunosdir/cawf/cawf >usr/bin/cawf
	    chown bin:bin usr/bin/cawf
	    chmod 755 usr/bin/cawf
	    rm -f usr/bin/nroff    
	    ln usr/bin/cawf usr/bin/nroff

	    rm -rf usr/lib/cawf
	    mkdir usr/lib/cawf
	    chown bin:bin usr/lib/cawf
	    chmod 755 usr/lib/cawf
	    sunread $sunosdir/cawf/common >usr/lib/cawf/common
	    sunread $sunosdir/cawf/device.cf >usr/lib/cawf/device.cf
	    sunread $sunosdir/cawf/dumb.dev >usr/lib/cawf/dumb.dev
	    sunread $sunosdir/cawf/man.mac >usr/lib/cawf/man.mac
	    sunread $sunosdir/cawf/me.mac >usr/lib/cawf/me.mac
	    sunread $sunosdir/cawf/ms.mac >usr/lib/cawf/ms.mac
	    sunread $sunosdir/cawf/mnx.mac >usr/lib/cawf/mnx.mac
	    chown bin:bin usr/lib/cawf/*
	    chmod 644 usr/lib/cawf/*
	    ;;

	  "chown")
	    sunread $sunosdir/simple/bin/chown >usr/bin/chown
	    chown bin:bin usr/bin/chown
	    chmod 755 usr/bin/chown
	    rm -f usr/bin/chgrp
	    ln usr/bin/chown usr/bin/chgrp
	    ;;

	  "compress")
	    sunread $sunosdir/simple/bin/compress >usr/bin/compress
	    chown bin:bin usr/bin/compress
	    chmod 755 usr/bin/compress
	    rm -f usr/bin/uncompress usr/bin/zcat
	    ln usr/bin/compress usr/bin/uncompress
	    ln usr/bin/compress usr/bin/zcat
	    ;;

	  "cp")
# This is a bit tricky, as we may be about to overwrite the basic file
# manipulation commands
	    mkdir tmpcp
            cp /bin/rm /bin/ln /bin/cp tmpcp
            sunread $sunosdir/simple/bin/cp >bin/cp
	    tmpcp/rm -f bin/clone bin/cpdir bin/ln bin/mv bin/rm
	    tmpcp/ln bin/cp bin/clone
	    tmpcp/ln bin/cp bin/cpdir
	    tmpcp/ln bin/cp bin/ln
	    tmpcp/ln bin/cp bin/mv
	    tmpcp/ln bin/cp bin/rm
	    tmpcp/cp bin/cp usr/bin/cp
	    rm -rf tmpcp
	    chown bin:bin bin/cp
	    chmod 755 bin/cp

	    rm -f usr/bin/clone usr/bin/cpdir usr/bin/ln usr/bin/mv usr/bin/rm
	    ln usr/bin/cp usr/bin/clone
	    ln usr/bin/cp usr/bin/cpdir
	    ln usr/bin/cp usr/bin/ln
	    ln usr/bin/cp usr/bin/mv
	    ln usr/bin/cp usr/bin/rm
	    chown bin:bin usr/bin/cp
	    chmod 755 usr/bin/cp
	    ;;

 	  "de")
	    sunread $sunosdir/de/de >usr/bin/de
	    chown bin:bin usr/bin/de
	    chmod 755 usr/bin/de
	    ;;

	  "elle")
	    sunread $sunosdir/elle/elle >usr/bin/elle
	    chown bin:bin usr/bin/elle
	    chmod 755 usr/bin/elle
	    sunread $sunosdir/elle/ellec >usr/bin/ellec
	    chown bin:bin usr/bin/ellec
	    chmod 755 usr/bin/ellec
	    ;;

	  "elvis")
	    sunread $sunosdir/elvis/elvis >usr/bin/elvis
	    chown bin:bin usr/bin/elvis
	    chmod 755 usr/bin/elvis
	    rm -f usr/bin/ex
	    ln usr/bin/elvis usr/bin/ex

	    sunread $sunosdir/elvis/ctags >usr/bin/ctags
	    chown bin:bin usr/bin/ctags
	    chmod 755 usr/bin/ctags

	    sunread $sunosdir/elvis/elvprsv >usr/bin/elvprsv
	    chown root:bin usr/bin/elvprsv
	    chmod 4755 usr/bin/elvprsv
	    
	    sunread $sunosdir/elvis/elvrec >usr/bin/elvrec
	    chown root:bin usr/bin/elvrec
	    chmod 4755 usr/bin/elvrec

	    sunread $sunosdir/elvis/fmt >usr/bin/fmt
	    chown bin:bin usr/bin/fmt
	    chmod 755 usr/bin/fmt
	    
	    sunread $sunosdir/elvis/ref >usr/bin/ref
	    chown bin:bin usr/bin/ref
	    chmod 755 usr/bin/ref
	    ;;

	  "ftp")
	    sunread $sunosdir/ftp/ftp >usr/bin/ftp
	    chown bin:bin usr/bin/ftp
	    chmod 755 usr/bin/ftp
	    ;;

	  "ic")
	    sunread $sunosdir/ic/ic >usr/bin/ic
	    chown bin:bin usr/bin/ic
	    chmod 755 usr/bin/ic
	    ;;

 	  "in.ftpd")
	    sunread $sunosdir/ftpd/in.ftpd >usr/bin/in.ftpd
	    sunread $sunosdir/ftpd/setup.anonftp >usr/bin/setup.anonftp
	    chown bin:bin usr/bin/in.ftpd usr/bin/setup.anonftp
	    chmod 755 usr/bin/in.ftpd usr/bin/setup.anonftp
	    ;;

 	  "in.telnetd")
	    sunread $sunosdir/telnetd/in.telnetd >usr/bin/in.telnetd
	    chown bin:bin usr/bin/in.telnetd
	    chmod 755 usr/bin/in.telnetd
	    ;;

	  "m4")
	    sunread $sunosdir/m4/m4 >usr/bin/m4
	    chown bin:bin usr/bin/m4
	    chmod 755 usr/bin/m4
	    ;;

	  "make")
	    sunread $sunosdir/make/make >usr/bin/make
	    chown bin:bin usr/bin/make
	    chmod 755 usr/bin/make
	    ;;

	  "mined")
	    sunread $sunosdir/mined/mined >usr/bin/mined
	    chown bin:bin usr/bin/mined
	    chmod 755 usr/bin/mined
	    ;;

	  "passwd")
	    sunread $sunosdir/simple/bin/passwd >usr/bin/passwd
	    chown root:bin usr/bin/passwd
	    chmod 4755 usr/bin/passwd
	    
	    rm -f usr/bin/chfn usr/bin/chsh
	    ln usr/bin/passwd usr/bin/chfn
	    ln usr/bin/passwd usr/bin/chsh
	    ;;

	  "patch")
	    sunread $sunosdir/patch/patch >usr/bin/patch
	    chown bin:bin usr/bin/patch
	    chmod 755 usr/bin/patch
	    ;;

          "pwdauth")
	    sunread $sunosdir/simple/bin/pwdauth >usr/lib/pwdauth
	    chown root:bin usr/lib/pwdauth
	    chmod 4755 usr/lib/pwdauth
	    ;;

	  "reboot")
	    sunread $sunosdir/reboot/halt >usr/bin/halt
	    chown root:operator usr/bin/halt
	    chmod 744 usr/bin/halt
	    rm -f usr/bin/reboot
	    ln usr/bin/halt usr/bin/reboot

	    cp usr/bin/halt bin/halt
	    chown root:operator bin/halt
	    chmod 744 bin/halt
	    rm -f bin/reboot
	    ln bin/halt bin/reboot

	    sunread $sunosdir/reboot/shutdown >usr/bin/shutdown
	    chown root:operator usr/bin/shutdown
	    chmod 4754 usr/bin/shutdown
	    ;;

	  "scripts")
	    for scr in DESCRIBE M MAKEDEV adduser checkhier makewhatis mkdist \
	     setup spell srccrc sunload svclog true whatis whereis
	    do
		sunread $sunosdir/scripts/$scr.sh >usr/bin/$scr
	        chown bin:bin usr/bin/$scr
	        chmod 755 usr/bin/$scr
	    done
	    cp usr/bin/sunload bin/sunload

	    rm -f usr/bin/U usr/bin/false usr/bin/apropos
            ln usr/bin/M usr/bin/U
            ln usr/bin/true usr/bin/false
	    ln usr/bin/whatis usr/bin/apropos

            cp usr/bin/M bin/M
	    cp usr/bin/true bin/true
	    chown bin:bin bin/M bin/true
	    rm -f bin/U bin/false
            ln bin/M bin/U
            ln bin/true bin/false
	    ;;

	  "sh")
	    sunread $sunosdir/sh/sh >usr/bin/sh
	    chmod 755 usr/bin/sh
	    cp usr/bin/sh bin/sh
	    chown bin:bin usr/bin/sh bin/sh
	    ;;

	  "sun4")
	    sunread $sunosdir/sun4/sunread >usr/bin/sunread
	    chmod 755 usr/bin/sunread
	    rm -f usr/bin/sunwrite
            ln usr/bin/sunread usr/bin/sunwrite
	    cp usr/bin/sunread bin/sunread
	    rm -f bin/sunwrite
            ln bin/sunread bin/sunwrite
	    chown bin:bin usr/bin/sunread bin/sunread
	    ;;

          "tcsh")
	    sunread $sunosdir/tcsh/tcsh >usr/bin/tcsh
	    chown bin:bin usr/bin/tcsh
	    chmod 755 usr/bin/tcsh
	    ;;

 	  "telnet")
	    sunread $sunosdir/telnet/ttn >usr/bin/telnet
	    chown bin:bin usr/bin/telnet
	    chmod 755 usr/bin/telnet
	    ;;

	  "test")
	    sunread $sunosdir/simple/bin/test >usr/bin/test
	    chmod 755 usr/bin/test
	    rm -f usr/bin/[
	    ln usr/bin/test usr/bin/[

	    cp usr/bin/test bin/test
	    rm -f bin/[
	    ln bin/test bin/[
	    chown bin:bin usr/bin/test bin/test
	    ;;

          "uemacs")
	    sunread $sunosdir/uemacs/uemacs >usr/bin/uemacs
	    chown bin:bin usr/bin/uemacs
	    chmod 755 usr/bin/uemacs
	    ;;

	  "uname")
	    sunread $sunosdir/simple/bin/uname >usr/bin/uname
	    chown bin:bin usr/bin/uname
	    chmod 755 usr/bin/uname
	    rm -f usr/bin/arch
	    ln usr/bin/uname usr/bin/arch
	    ;;

	  "uud")
	    sunread $sunosdir/simple/bin/uud >usr/bin/uud
	    chown bin:bin usr/bin/uud
	    chmod 755 usr/bin/uud
	    rm -f usr/bin/uudecode
	    ln usr/bin/uud usr/bin/uudecode
	    ;;

	  "uue")
	    sunread $sunosdir/simple/bin/uue >usr/bin/uue
	    chown bin:bin usr/bin/uue
	    chmod 755 usr/bin/uue
	    rm -f usr/bin/uuencode
	    ln usr/bin/uue usr/bin/uuencode
	    ;;

	  "yap")
	    sunread $sunosdir/yap/yap >usr/bin/yap
	    chown bin:bin usr/bin/yap
	    chmod 755 usr/bin/yap
	    rm -f usr/bin/more
	    ln usr/bin/yap usr/bin/more
	    ;;
          *) 
            echo Do not know how to load $binfile
 	    ;;
        esac
    fi
done
exit
