static char rcsid[] = "$Id: sunread.c,v 1.2 1996/06/04 08:51:33 paul Exp $";                                               
/*
 * sunread/sunwrite
 *
 * This smx program transfers a SunOS file to smx (if invoked under
 * the name sunread) and in the other direction if invoked under
 * the name sunwrite.  In both cases one command line argument is 
 * supplied---a SunOS pathname.  If the SunOS pathname is relative
 * then it is taken to be relative to the current directory when smx
 * was booted.  For sunread, the SunOS file read is written to stdout.
 * For sunwrite, the input is read from stdin.
 */

#include <minix/config.h>
#include <sun/signal.h>
#include <sun/syscall.h>
#include <stdio.h>
#include <string.h>

#define BUFSIZE 1024


/*
 * Function: main
 * Parameters: argc, argv - a single SunOS file name
 *
 * We can do everything in main.  The command line arg is processed,
 * and things initialised for reading or writing the SunOS file.
 * Then a loop is entered transferring a buffer at a time.  To keep
 * things simple, the IO and ALRM signals are disabled during
 * transfer to/from the SunOS file to prevent EINTR errors.  Letting
 * a user program disable interrupts is but this program is a special
 * case.
 */
int main(int argc, char *argv[])
{
    int fd, length, open_flags;
    so_sigset_t new;
    char *prog;
    char buf[BUFSIZE];
    int reading;
  
    prog = strrchr(*argv,'/');
    if (prog == (char *)0) {
	prog = *argv;
    } else {
	prog++;    /* step over '/' */
    }

    if (strcmp(prog, "sunread") == 0){
	reading = 1;
	open_flags = 0;       /* Open for reading */
    } else if (strcmp(prog, "sunwrite") == 0){
	reading = 0;
	open_flags = 0x301;   /* Open CREAT / TRUNC / WR_ONLY */
    } else {
	fprintf(stderr, "%s: program basename must be sunread or sunwrite\n",
		argv[0]);
	exit(1);
    }
    if (argc != 2){
	fprintf(stderr, "Usage: %s <SunOS filename>\n", argv[0]);
	exit(1);
    }
  
    sunsigemptyset(&new);
    sunsigaddset(&new, SO_SIGIO);
    sigaddset(&new, SO_SIGALRM);

    if ((fd = SunOS(SYS_open, argv[1], open_flags, 0666)) == -1){
	fprintf(stderr, "Can't open SunOS file: %s\n", argv[1]);
	exit(1);
    }

    do {	  
	if (reading) {
	    SunOS(SYS_sigprocmask, SO_SIG_BLOCK, &new, NULL);
	    length = SunOS(SYS_read, fd, buf, BUFSIZE);
	    SunOS(SYS_sigprocmask, SO_SIG_UNBLOCK, &new, NULL);
	    write(1, buf, length);
	} else {
	    length = read(0, buf, BUFSIZE);
	    SunOS(SYS_sigprocmask, SO_SIG_BLOCK, &new, NULL);
	    SunOS(SYS_write, fd, buf, length);
	    SunOS(SYS_sigprocmask, SO_SIG_UNBLOCK, &new, NULL);
	}
    } while (length != 0);
    SunOS(SYS_close, fd);
}
