/*
 * $Id: bootinfo.h,v 1.2 1996/07/09 19:41:28 paul Exp $
 * 
 * This file is used in smx only.
 *
 * The smx_bootinfo struct contains the information passed from the minix boot
 * strap program to the kernel.
 */

/*
 * The number of separate programs in 'image'
 */
#define NUM_PROGS 	(4 + ENABLE_NETWORKING)

#define KERNEL_PROG 	0
#define MM_PROG 	1
#define FS_PROG 	2
#define INET_PROG       3
#define INIT_PROG       (INET_PROG + ENABLE_NETWORKING)

/*
 * Each smx_proginfo structure contains information on one of the programs
 * loaded from the boot image: the number of text and data clicks the 
 * program has been loaded into (the data clicks include the data, gap
 * and stack, the virtual address at which the text and data segments
 * must be mapped to, and the virtual address of the program entry point.
 */
struct smx_proginfo {
    unsigned long text_clicks;
    unsigned long data_clicks;
    unsigned long text_vaddr;
    unsigned long data_vaddr;
    unsigned long entry;
};

struct smx_bootinfo {
    struct smx_proginfo prog[NUM_PROGS];   /* details of programs loaded */
    long mem_bytes;                        /* size of smx physical mem   */
    int debug;                             /* debuf flag */
    int prot_lev;
    ether_addr_t ether_addr;               /* "ethernet" address */
};
