! $Id: copySUN.s,v 1.3 1996/06/04 09:00:58 paul Exp $

#include <minix/config.h>
#include <minix/const.h>

!****************************************************************************
!
!     C O P Y _ S U N . S                                       M I N I X
!
!     Basic fast copy routines used by the kernel 
!****************************************************************************
!
! Contents:
!
!   real_zeroclicks   zero a block of clicks
!   real_copyclicks   copy a block of clicks
!   real_phys_copy    copy a block of bytes
!   test_and_set      Atomic testy and set of a specified byte
!
!============================================================================
!
!****************************************************************************

!****************************************************************************
!
!          r e a l _ z e r o c l i c k s
!
!          zero n clicks from source click to destination click address
!****************************************************************************
!
! Input:   
!       %i0 - physical destination click address
!       %i1 - number of clicks to zero
!
!****************************************************************************


        .global  real_zeroclicks
real_zeroclicks:
	save %sp, -96, %sp
	sll %i0,CLICK_SHIFT,%l0	  ! abs. source address
	sll %i1,CLICK_SHIFT-3,%l1 ! number of double words to zero
	mov %g0, %g1		  ! get two 0 registers
	tst %l1
zero00:
	be  zero01
	nop
	std %g0,[%l0]             ! zero out 8 bytes
	add %l0, 8, %l0           ! move on to next address
	ba  zero00
	deccc %l1                   ! one less to do

zero01:
	ret
	restore
	

!****************************************************************************
!
!          r e a l _ c o p y c l i c k s
!
!          copy n clicks from source click to destination click address
!****************************************************************************
!
! Input:
!       %i0 - physical source click address
!       %i1 - physical destination click address
!       %i2 - number of clicks to copy
!
!
!****************************************************************************

        .global  real_copyclicks
real_copyclicks:
	save %sp, -96, %sp
	sll %i0, CLICK_SHIFT, %l0   ! abs. source address
	sll %i1, CLICK_SHIFT, %l1   ! abs. destination address
	sll %i2, CLICK_SHIFT-3, %l2 ! length in double words
	tst %l2
copy00:
	be  copy01
	nop
	ldd [%l0], %l4              ! load copy
	std %l4, [%l1]              ! store copy
	add %l0, 8, %l0             ! update addresses
	add %l1, 8, %l1
	ba  copy00
	deccc %l2                     ! one less to do
copy01:
	ret
	restore
        


!****************************************************************************
!
!          r e a l _ p h y s _ c o p y
!
!          copy n bytes from source to destination address
!****************************************************************************
!
! Input:   
!       %i0 - physical source address ptr.
!       %i1 - physical destination address ptr.
!       %i2 - number of bytes to copy
!
! phys_copy is designed to determine which load and store instruction will
! perform the copy in the least. This decision depends on whether the source
! and destination are 8-byte aligned (use ldd), 4-byte aligned (use ld), 
! 2-byte aligned (use lduh) or not aligned (use ldub). It may be necessary
! to copy several bytes (using ldub) in order to make both the source and
! destination address aligned. eg. src = 6 dest =  798 can be be copied in
! lots of 8 as long as the first 2 bytes are copied by the byte.
!
!****************************************************************************

        .global  real_phys_copy
real_phys_copy:
	save %sp, -96, %sp
	mov %i0, %l0
	mov %i1, %l1
	mov %i2, %l2
	xor %l0, %l1, %l3	! find out how aligned src and dest are
	andcc %l3, 1, %g0
	bne pc1			! not aligned
        nop
        andcc %l3, 2, %g0
        bne pc2			! 2-byte
	nop
	andcc %l3, 4, %g0
	bne pc4			! 4-byte
	nop

	! else copy in multiples of 8 bytes 
pc8:
	sub %l0, 1, %l3
	and %l3, 7, %l3
	call pcbytes		! copy any initial bytes 
	xor %l3, 7, %l3
	ba pc8_1
	nop
	
pc8_2:
	ldd [%l0], %l4		! copy in groups of 8 
	std %l4, [%l1]
	inc 8, %l0
	inc 8, %l1
	dec 8, %l2
pc8_1:
	cmp %l2, 8
	bge pc8_2
	nop

	call pcbytes		! finish off any extra bytes 
	mov 8, %l3		! (copy up to 8 bytes) 
	ba pcexit
	nop


	! copy in lots of 4 bytes 	
pc4:
	sub %l0, 1, %l3
	and %l3, 3, %l3
	call pcbytes		! initial byte copying 
	xor %l3, 3, %l3
	ba pc4_1
	nop
	
pc4_2:
	ld  [%l0], %l4		! copy in groups of 4 
	st  %l4, [%l1]
	inc 4, %l0
	inc 4, %l1
	dec 4, %l2

pc4_1:
	cmp %l2, 4
	bge pc4_2
	nop
	call pcbytes		! finish off any extra bytes 
	mov 4,%l3		! (copy upto 4 bytes) 
	ba  pcexit
	nop

	! copy in groups of 2 
pc2:
	sub %l0, 1, %l3
	and %l3, 1, %l3
	call pcbytes		! initial alignment 
	xor %l3, 1, %l3
	ba  pc2_1
	nop
	

pc2_2:
	lduh [%l0],%l4		! copy 2 bytes at a time 
	sth %l4, [%l1]
	inc 2, %l0
	inc 2, %l1
	dec 2, %l2
pc2_1:
	cmp %l2,2
	bge pc2_2
	nop
	call pcbytes		! finish off any extra bytes 
	mov 2, %l3		! (copy upto 2 bytes) 
	ba  pcexit
	nop
	
	! copying byte by byte 
pc1:	call pcbytes
	mov %l2, %l3
	
pcexit:
	ret
	restore


! pcbytes is a local function for copying  unaligned initial or final
! portions byte by byte.  It assumes the following register contents,
! and uses %l7 for working storage:
!
! Input:   
!       %l0 - physical source address ptr.
!       %l1 - physical destination address ptr.
!       %l2 - number of bytes left to copy
!       %l3 - maximum number of bytes to copy
!
! pcbytes copies B bytes (min(%l2, %l3)) from the source to the destination.
! The address registers are increased by B, %l2 is decreased by B.
	
pcbytes:			! leaf routine 
        mov %l2, %l7            ! l7 = min(l2, l3)
	cmp %l7, %l3
	ble l2_less
	nop
	mov %l3, %l7
l2_less:	
	sub %l2, %l7, %l2       ! Decrease by the amount copied.

pcbytes_loop:	
	tst %l7
	be  pcbytes_end
	nop
	ldub [%l0], %l4
	stb %l4, [%l1]
	inc %l0
	inc %l1
	ba pcbytes_loop
	dec %l7
pcbytes_end:
	retl
	nop
	

!****************************************************************************
!
!          t e s t _ a n d _ s e t
!
!          Atomically reads the value of a byte and then sets the value to
!	   all 1's.
!
!          This function doesn't fit perfectly in this file, but it's 
!          copying in a broad sense (plus there aren't many other .s files!).
!****************************************************************************
!
! Input:   
!       %o0 - the address of the byte to be "test and set"
! Return value:	the previous value of the byte
!
!****************************************************************************

        .global  test_and_set
test_and_set:	
        ldstub [%o0], %o0
        retl
        nop

