#include "kernel.h"
#include <sun/syscall.h>

static char rcsid[] = "$Id: debug.c,v 1.3 1996/06/04 09:00:59 paul Exp $";

/*
 * Some primitive debug routines.  They give the ability to print
 * strings, characters and (decimal) integers directly to
 * descriptor 2 (stderr) of the SunOS process.  If the debug flag
 * is 0, no output is produced.
 */

static int debug;

void set_debug_level(int level)
{
    debug = level;
}

void debug_str(s)
char *s;
{
    char *lp;
    static int first = 1;
    
    if (debug) {
	for (lp = s ; *lp ; lp++)
	    ;
	if (lp != s) {
	    SunOS(SYS_write, 2, s, lp - s);
	}
    }
}


PUBLIC void debug_char(ch)
char ch;
{
    if (debug) {
	SunOS(SYS_write, 2, &ch, 1);
    }
}


PUBLIC void debug_int(i) 
int i;
{
    char s[20];
    int len;

    if (!debug) {
	return;
    }
    
    if (i < 0) {
	debug_char('-');
	i = -i;
    }
    if (i == 0) {
	debug_char('0');
    } else {
	for (len = 0 ; i != 0 ; len++) {
	    s[len] = '0' + i % 10;
	    i = i / 10;
	}
	len--;
	while (len >= 0) {
	    debug_char(s[len]);
	    len--;
	}
    }
}

