#include <stdio.h>
#include <ucontext.h>

/*
 * This is a standalone program that runs under SunOS.  Its purpose
 * is to compute and output various offsets into the ucontext
 * structure in the form of a .h file.  The size of the structure is 
 * defined in bytes; the other defines give offsets (treating the
 * context as an array of words) into the context of various
 * things of interest to smx.
 *
 * Output is to stdout.  The program is run from the Makefile, which
 * redirects stdout to an appropriate .h file.
 */
 
static void print_define(const char *name, int value)
{
    printf("#define %s %d\n", name, value);
}

int main(int argc, char *argv[])
{
    ucontext_t con;

    if (argc != 1) {
   	fprintf(stderr, "Usage: %s\n", argv[0]);
	exit(1);
    }

    printf("/* Do not change this file: it is generated by make_offset */\n");

    print_define("UC_SIZE", sizeof(con));
    print_define("GWIN_SIZE", sizeof(*con.uc_mcontext.gwins));
    print_define("UC_FLAGS",
	         (unsigned *) &con.uc_flags - (unsigned *) &con);
    print_define("UC_SIGMASK",
	         (unsigned *) &con.uc_sigmask - (unsigned *) &con);
    print_define("UC_SP",
	         (unsigned *) &con.uc_stack.ss_sp - (unsigned *) &con);
    print_define("UC_PSW",
	         (unsigned *) &con.uc_mcontext.gregs - (unsigned *) &con);
    print_define("UC_GWINS", 
	         (unsigned *) &con.uc_mcontext.gwins - (unsigned *) &con);
    print_define("UC_FPU_Q",
  	      (unsigned *) &con.uc_mcontext.fpregs.fpu_q - (unsigned *) &con);
    return 0;
}
