! $Id: startSUN.s,v 1.3 1996/06/04 09:01:33 paul Exp $

#include <minix/config.h>
#include <minix/const.h>
#include "const.h"

! This is kernel entry point which is jumped to by the boot strap program.

	.global start
start:
	set k_stack, %l0
	set CLICK_SIZE-1, %l1   ! Align %sp on the next lowest click
	andn %l0, %l1, %sp      ! boundary (for protection reasons)

	set savedsp, %l0        ! Remember where the kernel stack
	st %sp,[%l0]            ! ends
	
	sub %sp, 8, %sp         ! sp now points to the last double word in a
				! click
	sub %sp, INIT_SP, %sp   ! leave space for a stack frame

	call main               ! Execute the C startup code
	nop

L0:	ba L0                   ! Should never return
	nop


! getksp takes no parameters, and returns the highest address + 1 of the
! kernel stack.	
	
        .global getksp
getksp:
	set savedsp,%o0
	retl
	ld [%o0],%o0


	.seg "bss"
! Place to save the top of the stack.
	.align 4
savedsp:	
	.skip 4


! Here is the "kernel stack".  It is used by the bootstrap code,
! and by all layer 1 (interrupt handler) code.  K_STACK_BYTES are used,
! but CLICK_SIZE bytes are added to this so that we can be sure of
! having a click-aligned K_STACK_BYTES region (the bss segment doesn't
! start on a click boundary).  This is important for proection, as
! all bytes in a click have the same protection.  See src/kernel/sunprotect.c
! for more info on protection
	
	.seg "bss"
	.align 8
	.skip K_STACK_BYTES + CLICK_SIZE 	! leave click aligned space
k_stack:          ! label the top of the stack
