/*
 * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * See the copyright notice in the ACK home directory, in the file "Copyright".
 */
/* $Header: /users/cosc/staff/paul/CVS/minix1.7/src/lib/ansi/getenv.c,v 1.2 1996/04/10 21:04:19 paul Exp $ */

#include	<stdlib.h>

extern const char **_penvp;

char *
getenv(const char *name)
{
	register const char **v = _penvp;
	register const char *p, *q;

	if (v == NULL || name == NULL)
		return (char *)NULL;
	while ((p = *v++) != NULL) {
		q = name;
		while (*q && (*q == *p++))
			q++;
		if (*q || (*p != '='))
			continue;
		return (char *)p + 1;
	}
	return (char *)NULL;
}
