/*
 * (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * See the copyright notice in the ACK home directory, in the file "Copyright".
 */
/* $Header: /users/cosc/staff/paul/CVS/minix1.7/src/lib/ansi/memcmp.c,v 1.2 1996/04/10 21:04:53 paul Exp $ */

#include	<string.h>

int
memcmp(const void *s1, const void *s2, size_t n)
{
	register const char *p1 = s1, *p2 = s2;

	if (n) {
		n++;
		while (--n > 0) {
			if (*p1++ == *p2++) continue;
			return *--p1 - *--p2;
		}
	}
	return 0;
}
