! $Id: crtso.s,v 1.3 1996/06/04 09:12:54 paul Exp $

! This is the C run-time start-off routine for user programs. 
! It's job is to take the arguments as put on the stack by EXEC, 
! and to pass the appropriate arguments to main

#include <minix/config.h>

#define _ASM
#include <minix/const.h>


! public labels
	.global	_penvp      ! getenv and system use it to find the environment
                            ! The environ variable can't be relied on as the
	                    ! program may define one (see below).
 
	.global _crtso      ! Entry point 
	.seg "text"

! The parameters and environment are found on the stack, and were put there
! by MM while performing an exec.  In the case of the SPARC they are
! 96 above the current sp (the standard SPARC stack frame size).
! The arg/envp package begins with:  argc, argc + 1 char pointers (the
! argv array), the envp char pointers.

_crtso:	
	add %sp, INIT_SP, %l0      ! Work out where arg/env package starts
	ld  [%l0], %l1             ! First comes argc
	add %l0, 4, %l0            ! Next argv (l0 points to the array start)
	add %l1, 1, %l2            ! l2 is argc + 1 (allow for the null
	                           !    pointer at the end of the argv array).
	sll %l2, 2, %l2            ! l2 is the size of the argv ptr array
	add %l0, %l2, %l3          ! l3 points to the envp array

	set _penvp, %l4
	st %l3, [%l4]		   ! initialise _penvp

	set environ, %l4           ! environ is initialised to the same value
	ld  [%l4], %l5             !    if we are picking up the library
	set 0x53535353, %l6        !    environ variable, which we can
	cmp %l5, %l6               !    tell be checking for the magic value
	bne user_environ           !    it is initialised to 
	nop                        !    (see lib/other/environ.c).
	st  %l3, [%l4]		   ! store in environ 
	
user_environ:	                   ! main(argv, argc, _penvp)
	mov %l3, %o2		   ! "push" environment
	mov %l0, %o1		   ! "push" argv
	call main
	mov %l1, %o0		   ! "push" argc

	call exit		   ! exit status put in %o0 by main
	nop

_L0:	ba,a _L0                   ! should never get here!!!!!!
	nop

	.seg "data"

_penvp:
	.word	0
