! $Id: sndrec.s,v 1.3 1996/06/04 09:13:02 paul Exp $ 

! This code is included in Minix programs that send messages. The send/rec
! parameters are put onto the stack and a SunOS SIGUSR1 signal is sent to
! the currently executing SunOS process (i.e. smx).  For some reason,
! there seems to be a race condition with this code, so the signal
! mask is set to block out the asynchronous SunOS signals during
! the period in which the signal is delivered.	
	
#include <minix/config.h>

#define _ASM
#include <sun/syscall.h>
#include <sun/signal.h>
	
	.global _send, _receive, _sendrec	
	
	SEND 		= 1
	RECEIVE 	= 2
	BOTH 		= 3

! We have three different entry points.  Each sets l0 to contain
! the appropriate code of those above, and form then on execution
! is the same for all three.

_send:
	save %sp, -104, %sp
	ba   L0
	mov  SEND, %l0

_receive:
	save %sp, -104, %sp
	ba   L0
	mov  RECEIVE, %l0

_sendrec:
	save %sp, -104, %sp
	mov  BOTH, %l0

L0:                              
	set _ourpid, %l7
	ld [%l7], %o0
	tst %o0                  ! Have we got our SunOS pid yet?
	bge gotpid
	nop
	
	call SunOS               ! No---get it ...
	mov SYS_getpid, %o0
	st %o0, [%l7]	         !  ... and save it

gotpid:	                         ! store parameters on the stack
	st %l0,[%sp + 92] 	 ! SEND/RECEIVE/BOTH
	st %i0,[%sp + 96]        ! src/dest
	st %i1,[%sp + 100]       ! message pointer

	mov SYS_sigprocmask,%o0  ! Shut out asynchronous signals
	mov SO_SIG_SETMASK, %o1
        set sigoff,%o2
	call SunOS
	mov %g0,%o3

	mov %o0, %o1             ! kill(pid, SIGUSR1)
	mov SYS_kill, %o0
	call SunOS
	mov SO_SIGUSR1, %o2

	mov %o0,%i0              ! The return value is the overall ret value

	mov SYS_sigprocmask, %o0 ! Allow asynchronous signals
	mov SO_SIG_SETMASK, %o1
        set sigon, %o2
	call SunOS
	mov %g0, %o3

	ret
	restore

	.seg "data"

_ourpid: .word -1                ! Cache our SunOS pid here
sigoff:	.word 0x202000,0,0,0     ! Block out ALRM (14) and IO (22).
sigon:	.word 0,0,0,0
