! $Id: __sigreturn.s,v 1.2 1996/06/04 09:13:47 paul Exp $

! When a signal handler is installed by sigaction, it is passed the
! address of __sigreturn as the function to invoke in order to have
! the signal handler invoked.  Registers %o0, %o1, %o2 and %o5 are
! set up (in this process' context) by the system task before the call.
! %o0, %o1 and %o2 are the parameters to pass to the signal handler.  A copy
! of the third paramter (which points to the saved context structure)
! is kept so that it can be supplied to _sigreturn to specify the
! context to be restored.  %o5 contains the address of the signal
! handler.

        .global	__sigreturn
__sigreturn:
	mov	%o2,%l0     ! Save sigcontext for the restore later
	call    %o5
	nop

	ba	_sigreturn
	mov	%l0, %o0    ! Pass the sigcontext to _sigreturn 
	! which never comes back!!!
