/* $Id: const.h,v 1.2 1996/03/20 20:08:25 paul Exp $ */

/* Copyright (C) 1995 by Prentice-Hall, Inc.  Permission is hereby granted
 * to redistribute the binary and source programs of this system for
 * educational or research purposes.  For other use, written permission from
 * Prentice-Hall is required.  
 */

#define EXTERN        extern	/* used in *.h files */
#define PRIVATE       static	/* PRIVATE x limits the scope of x */
#define PUBLIC			/* PUBLIC is the opposite of PRIVATE */
#define FORWARD       static	/* some compilers require this to be 'static'*/

#define TRUE               1	/* used for turning integers into Booleans */
#define FALSE              0	/* used for turning integers into Booleans */

#define HZ	          20	/* clock freq (software settable on IBM-PC) */
#define BLOCK_SIZE      1024	/* # bytes in a disk block */
#define SUPER_USER (uid_t) 0	/* uid_t of superuser */

#define MAJOR	           8	/* major device = (dev>>MAJOR) & 0377 */
#define MINOR	           0	/* minor device = (dev>>MINOR) & 0377 */

#define NULL     ((void *)0)	/* null pointer */
#define CPVEC_NR          16	/* max # of entries in a SYS_VCOPY request */
#define NR_IOREQS	MIN(NR_BUFS, 64)
				/* maximum number of entries in an iorequest */

#define NR_SEGS            3	/* # segments per process */
#define T                  0	/* proc[i].mem_map[T] is for text */
#define D                  1	/* proc[i].mem_map[D] is for data */
#define S                  2	/* proc[i].mem_map[S] is for stack */

/* Process numbers of some important processes. */
#define MM_PROC_NR         0	/* process number of memory manager */
#define FS_PROC_NR         1	/* process number of file system */
#define INET_PROC_NR       2	/* process number of the TCP/IP server */
#define INIT_PROC_NR	(INET_PROC_NR + ENABLE_NETWORKING)
				/* init -- the process that goes multiuser */
#define LOW_USER	(INET_PROC_NR + ENABLE_NETWORKING)
				/* first user not part of operating system */

/* Miscellaneous */
#define BYTE            0377	/* mask for 8 bits */
#define READING            0	/* copy data to user */
#define WRITING            1	/* copy data from user */
#define NO_NUM        0x8000	/* used as numerical argument to panic() */
#define NIL_PTR   (char *) 0	/* generally useful expression */
#define HAVE_SCATTERED_IO  1	/* scattered I/O is now standard */

/* How many bytes are pushed by a signal. */
#if (CHIP == SPARC)
#define stack_align(sp) ((sp) & ~7)   /*must be aligned on an 8 byte boundary*/
/*
 * Register defines
 */
#define Y  wbuf[0]
#define O0 wbuf[8]
#define retreg O0             /* o0 is the return register */
#define O1 wbuf[9]
#define O2 wbuf[10]
#define O3 wbuf[11]
#define O4 wbuf[12]
#define O5 wbuf[13]
#define O6 wbuf[14]
#define O7 wbuf[15]
#define return_address O7
#define I0 wbuf[24]
#define I6 wbuf[30]
#define FP I6


#define INIT_SP 96    /* 96 bytes in a minimal SPARC stack frame */

#ifdef SOLARIS
#define SIG_PUSH_BYTES ((46 + 18) * sizeof(int))
#else
#define SIG_PUSH_BYTES ((73 + 18) * sizeof(int))
#endif
#elif ((CHIP == M68000) && (MACHINE == SUN))
/* sizeof(stackframe_s) + # words picked up in build_sig, system.c */
#define SIG_PUSH_BYTES ((20 + 2) * sizeof(int))
#else
#define SIG_PUSH_BYTES (sizeof(int)+sizeof(u16_t)+sizeof(u32_t)) 
#endif

/* Macros. */
#define MAX(a, b)   ((a) > (b) ? (a) : (b))
#define MIN(a, b)   ((a) < (b) ? (a) : (b))

/* Number of tasks. */
#define NR_TASKS	(9 + ENABLE_SCSI + ENABLE_CDROM + ENABLE_NETWORKING \
			+ 2 * ENABLE_AUDIO)

/* Memory is allocated in clicks. */
#if (CHIP == INTEL)
#define CLICK_SIZE       256	/* unit in which memory is allocated */
#define CLICK_SHIFT        8	/* log2 of CLICK_SIZE */
#endif

#if (CHIP == SPARC) || (CHIP == M68000)
#define CLICK_SIZE	4096	/* unit in which memory is alocated */
#define CLICK_SHIFT	  12	/* 2log of CLICK_SIZE */
#endif

#define click_to_round_k(n) \
	((unsigned) ((((unsigned long) (n) << CLICK_SHIFT) + 512) / 1024))
#if CLICK_SIZE < 1024
#define k_to_click(n) ((n) * (1024 / CLICK_SIZE))
#else
#define k_to_click(n) ((n) / (CLICK_SIZE / 1024))
#endif

#define ABS             -999	/* this process means absolute memory */

/* Flag bits for i_mode in the inode. */
#define I_TYPE          0170000	/* this field gives inode type */
#define I_REGULAR       0100000	/* regular file, not dir or special */
#define I_BLOCK_SPECIAL 0060000	/* block special file */
#define I_DIRECTORY     0040000	/* file is a directory */
#define I_CHAR_SPECIAL  0020000	/* character special file */
#define I_NAMED_PIPE	0010000 /* named pipe (FIFO) */
#define I_SET_UID_BIT   0004000	/* set effective uid_t on exec */
#define I_SET_GID_BIT   0002000	/* set effective gid_t on exec */
#define ALL_MODES       0006777	/* all bits for user, group and others */
#define RWX_MODES       0000777	/* mode bits for RWX only */
#define R_BIT           0000004	/* Rwx protection bit */
#define W_BIT           0000002	/* rWx protection bit */
#define X_BIT           0000001	/* rwX protection bit */
#define I_NOT_ALLOC     0000000	/* this inode is free */

/* Memory management protection flags */
#define PROT_READ        0x1       /* page can be read */
#define PROT_WRITE       0x2       /* page can be written */
#define PROT_EXEC        0x4       /* page can be executed */
#define PROT_NONE        0x0       /* page can not be accessed */
#define PROT_NOW         0x8       /* should protection be changed now */

#define PROT_ALL (PROT_READ | PROT_WRITE | PROT_EXEC)
#define PROT_READ_EXEC (PROT_READ | PROT_EXEC)
#define PROT_READ_WRITE (PROT_READ | PROT_WRITE)

/* Some limits. */
#define MAX_BLOCK_NR  ((block_t) 077777777)	/* largest block number */
#define HIGHEST_ZONE   ((zone_t) 077777777)	/* largest zone number */
#define MAX_INODE_NR      ((ino_t) 0177777)	/* largest inode number */
#define MAX_FILE_POS ((off_t) 037777777777)	/* largest legal file offset */

#define NO_BLOCK              ((block_t) 0)	/* absence of a block number */
#define NO_ENTRY                ((ino_t) 0)	/* absence of a dir entry */
#define NO_ZONE                ((zone_t) 0)	/* absence of a zone number */
#define NO_DEV                  ((dev_t) 0)	/* absence of a device numb */
