/* $Id: signal.h,v 1.1 1996/03/20 20:08:36 paul Exp $ */

#ifndef	__signal_h
#define	__signal_h

#if (MACHINE == SUN)
#ifdef SOLARIS
/* Solaris signal structures and constants */

/* Must be equal to sizeof(so_sigset_t) */
#define SO_SIGSET_BYTES 16

#ifndef _ASM

typedef struct {                /* signal set type */
    unsigned long   __sigbits[4];
} so_sigset_t;

struct so_sigaction {
    int sa_flags;
    void (*sa_handler)();
    so_sigset_t sa_mask;
    int sa_resv[2];
};


struct so_sigaltstack {
    char    *ss_sp;
    int     ss_size;
    int     ss_flags;
};

typedef struct sigaltstack so_stack_t;

#endif
/* definitions for the sa_flags field */
#define SUN_SA_ONSTACK      0x00000001
#define SUN_SA_RESETHAND    0x00000002
#define SUN_SA_RESTART      0x00000004
#define SUN_SA_SIGINFO      0x00000008
#define SUN_SA_NODEFER      0x00000010

#define sunsigmask(n)              ((unsigned int)1 << (((n) - 1) & (32 - 1)))
#define sunsigword(n)              (((unsigned int)((n) - 1))>>5)

#define sunsigemptyset(s)          ((long)((s)->__sigbits[0]) = 0L)
#define sunsigmakeset(s, n)        ((long)((s)->__sigbits[0]) = (long)n)
			
#define sunsigaddset(s, n)         ((s)->__sigbits[sunsigword(n)] |= sunsigmask(n))
#define sunsigdelset(s, n)         ((s)->__sigbits[sunsigword(n)] &= ~sunsigmask(n))

#define SO_SIG_BLOCK       1
#define SO_SIG_UNBLOCK     2
#define SO_SIG_SETMASK     3

#define SO_SIGHUP  1       /* hangup */
#define SO_SIGINT  2       /* interrupt (rubout) */
#define SO_SIGQUIT 3       /* quit (ASCII FS) */
#define SO_SIGILL  4       /* illegal instruction (not reset when caught) */
#define SO_SIGTRAP 5       /* trace trap (not reset when caught) */
#define SO_SIGIOT  6       /* IOT instruction */
#define SO_SIGABRT 6       /* used by abort, replace SIGIOT in the future */
#define SO_SIGEMT  7       /* EMT instruction */
#define SO_SIGFPE  8       /* floating point exception */
#define SO_SIGKILL 9       /* kill (cannot be caught or ignored) */
#define SO_SIGBUS  10      /* bus error */
#define SO_SIGSEGV 11      /* segmentation violation */
#define SO_SIGSYS  12      /* bad argument to system call */
#define SO_SIGPIPE 13      /* write on a pipe with no one to read it */
#define SO_SIGALRM 14      /* alarm clock */
#define SO_SIGTERM 15      /* software termination signal from kill */
#define SO_SIGUSR1 16      /* user defined signal 1 */
#define SO_SIGUSR2 17      /* user defined signal 2 */
#define SO_SIGCLD  18      /* child status change */
#define SO_SIGPWR  19      /* power-fail restart */
#define SO_SIGWINCH 20     /* window size change */
#define SO_SIGURG  21      /* urgent socket condition */
#define SO_SIGPOLL 22      /* pollable event occured */
#define SO_SIGIO   SO_SIGPOLL /* socket I/O possible (SIGPOLL alias) */
#define SO_SIGSTOP 23      /* stop (cannot be caught or ignored) */
#define SO_SIGTSTP 24      /* user stop requested from tty */
#define SO_SIGCONT 25      /* stopped process has been continued */
#define SO_SIGTTIN 26      /* background tty read attempted */
#define SO_SIGTTOU 27      /* background tty write attempted */
#define SO_SIGVTALRM 28    /* virtual timer expired */
#define SO_SIGPROF 29      /* profiling timer expired */
#define SO_SIGXCPU 30      /* exceeded cpu limit */
#define SO_SIGXFSZ 31      /* exceeded file size limit */
#define SO_SIGWAITING 32   /* process's lwps are blocked */
#define SO_SIGLWP  33      /* special signal used by thread library */
#define _SIGRTMIN 36    /* first (highest-priority) realtime signal */
#define _SIGRTMAX 43    /* last (lowest-priority) realtime signal */

#endif

#endif /* MACHINE == SUN */

#endif	/* !__signal_h */
