/* $Id: IN.h,v 1.1 1996/03/20 21:38:16 paul Exp $ */

typedef struct INnode INnode_t;

struct INnode {
    struct ev_record ev;
    void *rest;
    evtype_t    evtype;
    INnode_t     *next, *fork;    /* forward pointers */
    INnode_t     *prev, *join;    /* reverse pointers */
    int          ref_cnt;
    unsigned int visited:1;       /* used in IN traversals */
    int seq_no;                   /* unique id for a node */
    void *user_hook;              /* per-event user data can be added here */
};

typedef void (*free_spare_func)(void *spare);

INnode_t *log_readIN(char *filename);
void log_freeIN(INnode_t *ip, free_spare_func);
void log_IN_visited_reset(INnode_t *ip);

void log_stn_sym_add(symptr sym_table, int stn, void *user_data);
void *log_stn_sym_find(symptr sym_table, int stn, int error_fatal);
void log_stn_sym_delete(symptr sym_table, int stn);
