/* $Id: logging.h,v 1.1 1996/03/20 21:38:52 paul Exp $ */

/*
 * Events are not recorded for processes that have INVALID_STN as
 * their sub-task number.
 */
#define INVALID_STN -1

/*
 * Message types that can be recorded.
 */
#define EV_TTY_INPUT 1    /* Input characters have been copied to a user */
                          /* process by the tty task.  The first event in */
                          /* a task */
#define EV_MSG_BLOCK 2    /* A process has blocked waiting to send or receive*/
#define EV_MSG_SEND  3    /* A process has just sent a message. */
#define EV_MSG_RECV  4    /* A process has just received a message. */
#define EV_FORK      5    /* A new proces has been created (always recorded */
                          /* in the system task). */
#define EV_EXIT      6    /* A process has terminated. */
#define EV_SINK      7    /* A process has finished its involvement with a */
                          /* task (generated by insplit during analysis). */
#define EV_NEW_NAME  8    /* A new process name has been specified as the */
                          /* result of an exec system call. */
			     

/*
 * When an event occurs, an ev_record structure is written to the log file.
 * Following that record are e_bufflen bytes of event-dependent data.
 * Currently, three event types have event-dependent data:
 *
 *     EV_TTY_INPUT: the input characters copied.
 *     EV_MSG_RECV:  an integer that contains the type of the message received.
 *     EV_NEW_NAME:  a null-terminated string that contains the new process
 *                   name.
 */

struct ev_record {
    int e_event;        /* One of the event types defined above. */
    int e_pnr;          /* The number of the process in which the event */
                        /* occurred. */
    int e_stn;          /* Sub-task number of the process when the event */
                        /* occurred. */
    int e_other_stn;    /* For "fork"-type events, the sub-task number of */
                        /* the new piece of work (process or message).  For */
                        /* "join"-type events, the sub-task number that the */
                        /* process had before the message was received. */
    int e_secs;         /* Time (in seconds and microseconds) at which the */
    int e_usecs;        /* event occurred. */
    int e_bufflen;      /* Number of bytes of event-dependent information. */
};

extern int logging_enabled;
