/*
 * messages
 *
 * Revision history
 * 950812 CIM Initial coding.
 * 951214 PJA Update for Minix 1.7.1
 *
 */

/*
 * This code is written for the set of software tools that decode log files
 * from Minix.  It contains one procedure message_is which takes two
 * parameters, destination process and message number, and it will return
 * a string describing the message.
 */
#define _SYSTEM
#include "messages.h"
#include "../../../include/minix/com.h"
#include "../../../include/minix/callnr.h"
#include "../../../include/errno.h"
#include "../../../include/minix/config.h"
#include "../../../include/minix/const.h"
#include <stdio.h>
#include <string.h>

void
message_is(int dest, int type, char *text, int textlen)
{
    text[0] = '\0';

    if (dest < LOW_USER) {
	switch (dest) {
	  case TTY:
	  case PRINTER:
	    switch (type) {
	      case HARD_INT:
		strncpy(text, "HARD_INT", textlen - 1);
		break;
	      case DEV_READ:
		strncpy(text, "DEV_READ", textlen - 1);
		break;
	      case DEV_WRITE:
		strncpy(text, "DEV_WRITE", textlen - 1);
		break;
	      case DEV_IOCTL:
		strncpy(text, "DEV_IOCTL", textlen - 1);
		break;
	      case DEV_OPEN:
		strncpy(text, "DEV_OPEN", textlen - 1);
		break;
	      case DEV_CLOSE:
		strncpy(text, "DEV_CLOSE", textlen - 1);
		break;
	      case CANCEL:
		strncpy(text, "CANCEL", textlen - 1);
		break;
	    }
	    break;

	  case MEM:
	  case WINCHESTER:
	  case FLOPPY:
	    switch (type) {
	      case DEV_OPEN:
		strncpy(text, "DEV_OPEN", textlen - 1);
		break;
	      case DEV_CLOSE:
		strncpy(text, "DEV_CLOSE", textlen - 1);
		break;
	      case DEV_IOCTL:
		strncpy(text, "DEV_IOCTL", textlen - 1);
		break;
	      case DEV_READ:
		strncpy(text, "DEV_READ", textlen - 1);
		break;
	      case DEV_WRITE:
		strncpy(text, "DEV_WRITE", textlen - 1);
		break;
	      case SCATTERED_IO:
		strncpy(text, "SCATTERED_IO", textlen - 1);
		break;
	    }
	    break;

	  case CLOCK:
	    switch (type) {
	      case HARD_INT:
		strncpy(text, "HARD_INT", textlen - 1);
		break;
	      case GET_TIME:
		strncpy(text, "GET_TIME", textlen - 1);
		break;
	      case SET_TIME:
		strncpy(text, "SET_TIME", textlen - 1);
		break;
	      case SET_ALARM:
		strncpy(text, "SET_ALARM", textlen - 1);
		break;
	      case GET_UPTIME:
		strncpy(text, "GET_UPTIME", textlen - 1);
		break;
	      case SET_SYNC_AL:
		strncpy(text, "SET_SYNC_AL", textlen - 1);
		break;
	    }
	    break;
	    
	  case SYSTASK:
	    switch (type) {
	      case SYS_FORK:
		strncpy(text, "SYS_FORK", textlen - 1);
		break;
	      case SYS_NEWMAP:
		strncpy(text, "SYS_NEWMAP", textlen - 1);
		break;
	      case SYS_EXEC:
		strncpy(text, "SYS_EXEC", textlen - 1);
		break;
	      case SYS_XIT:
		strncpy(text, "SYS_XIT", textlen - 1);
		break;
	      case SYS_GETSP:
		strncpy(text, "SYS_GETSP", textlen - 1);
		break;
	      case SYS_TIMES:
		strncpy(text, "SYS_TIMES", textlen - 1);
		break;
	      case SYS_ABORT:
		strncpy(text, "SYS_ABORT", textlen - 1);
		break;
	      case SYS_FRESH:
		strncpy(text, "SYS_FRESH", textlen - 1);
		break;
	      case SYS_SENDSIG:
		strncpy(text, "SYS_SENDSIG", textlen - 1);
		break;
	      case SYS_SIGRETURN:
		strncpy(text, "SYS_SIGRETURN", textlen - 1);
		break;
	      case SYS_ENDSIG:
		strncpy(text, "SYS_ENDSIG", textlen - 1);
		break;
	      case SYS_OLDSIG:
		strncpy(text, "SYS_OLDSIG", textlen - 1);
		break;
	      case SYS_KILL:
		strncpy(text, "SYS_KILL", textlen - 1);
		break;
	      case SYS_COPY:
		strncpy(text, "SYS_COPY", textlen - 1);
		break;
	      case SYS_VCOPY:
		strncpy(text, "SYS_VCOPY", textlen - 1);
		break;
	      case SYS_GBOOT:
		strncpy(text, "SYS_GBOOT", textlen - 1);
		break;
	      case SYS_UMAP:
		strncpy(text, "SYS_UMAP", textlen - 1);
		break;
	      case SYS_MEM:
		strncpy(text, "SYS_MEM", textlen - 1);
		break;
	      case SYS_TRACE:
		strncpy(text, "SYS_TRACE", textlen - 1);
		break;
	      case SYS_GETMAP:
		strncpy(text, "SYS_GETMAP", textlen - 1);
		break;
	      case SYS_MPROT:
		strncpy(text, "SYS_MPROT", textlen - 1);
		break;
	    }
	    break;

	  case MM_PROC_NR:
	  case FS_PROC_NR:
	    switch (type) {
	      case EXIT:
		strncpy(text, "EXIT", textlen - 1);
		break;
	      case FORK:
		strncpy(text, "FORK", textlen - 1);
		break;
	      case READ:
		strncpy(text, "READ", textlen - 1);
		break;
	      case WRITE:
		strncpy(text, "WRITE", textlen - 1);
		break;
	      case OPEN:
		strncpy(text, "OPEN", textlen - 1);
		break;
	      case CLOSE:
		strncpy(text, "CLOSE", textlen - 1);
		break;
	      case WAIT:
		strncpy(text, "WAIT", textlen - 1);
		break;
	      case CREAT:
		strncpy(text, "CREAT", textlen - 1);
		break;
	      case LINK:
		strncpy(text, "LINK", textlen - 1);
		break;
	      case UNLINK:
		strncpy(text, "UNLINK", textlen - 1);
		break;
	      case WAITPID:
		strncpy(text, "WAITPID", textlen - 1);
		break;
	      case CHDIR:
		strncpy(text, "CHDIR", textlen - 1);
		break;
	      case TIME:
		strncpy(text, "TIME", textlen - 1);
		break;
	      case MKNOD:
		strncpy(text, "MKNOD", textlen - 1);
		break;
	      case CHMOD:
		strncpy(text, "CHMOD", textlen - 1);
		break;
	      case CHOWN:
		strncpy(text, "CHOWN", textlen - 1);
		break;
	      case BRK:
		strncpy(text, "BRK", textlen - 1);
		break;
	      case STAT:
		strncpy(text, "STAT", textlen - 1);
		break;
	      case LSEEK:
		strncpy(text, "LSEEK", textlen - 1);
		break;
	      case GETPID:
		strncpy(text, "GETPID", textlen - 1);
		break;
	      case MOUNT:
		strncpy(text, "MOUNT", textlen - 1);
		break;
	      case UMOUNT:
		strncpy(text, "UMOUNT", textlen - 1);
		break;
	      case SETUID:
		strncpy(text, "SETUID", textlen - 1);
		break;
	      case GETUID:
		strncpy(text, "GETUID", textlen - 1);
		break;
	      case STIME:
		strncpy(text, "STIME", textlen - 1);
		break;
	      case PTRACE:
		strncpy(text, "PTRACE", textlen - 1);
		break;
	      case ALARM:
		strncpy(text, "ALARM", textlen - 1);
		break;
	      case FSTAT:
		strncpy(text, "FSTAT", textlen - 1);
		break;
	      case PAUSE:
		strncpy(text, "PAUSE", textlen - 1);
		break;
	      case UTIME:
		strncpy(text, "UTIME", textlen - 1);
		break;
	      case ACCESS:
		strncpy(text, "ACCESS", textlen - 1);
		break;
	      case SYNC:
		strncpy(text, "SYNC", textlen - 1);
		break;
	      case KILL:
		strncpy(text, "KILL", textlen - 1);
		break;
	      case RENAME:
		strncpy(text, "RENAME", textlen - 1);
		break;
	      case MKDIR:
		strncpy(text, "MKDIR", textlen - 1);
		break;
	      case RMDIR:
		strncpy(text, "RMDIR", textlen - 1);
		break;
	      case DUP:
		strncpy(text, "DUP", textlen - 1);
		break;
	      case PIPE:
		strncpy(text, "PIPE", textlen - 1);
		break;
	      case TIMES:
		strncpy(text, "TIMES", textlen - 1);
		break;
	      case SETGID:
		strncpy(text, "SETGID", textlen - 1);
		break;
	      case GETGID:
		strncpy(text, "GETGID", textlen - 1);
		break;
	      case SIGNAL:
		strncpy(text, "SIGNAL", textlen - 1);
		break;
	      case IOCTL:
		strncpy(text, "IOCTL", textlen - 1);
		break;
	      case FCNTL:
		strncpy(text, "FCNTL", textlen - 1);
		break;
	      case EXEC:
		strncpy(text, "EXEC", textlen - 1);
		break;
	      case UMASK:
		strncpy(text, "UMASK", textlen - 1);
		break;
	      case CHROOT:
		strncpy(text, "CHROOT", textlen - 1);
		break;
	      case SETSID:
		strncpy(text, "SETSID", textlen - 1);
		break;
	      case GETPGRP:
		strncpy(text, "GETPGRP", textlen - 1);
		break;
	      case KSIG:
		strncpy(text, "KSIG", textlen - 1);
		break;
	      case UNPAUSE:
		strncpy(text, "UNPAUSE", textlen - 1);
		break;
	      case REVIVE:
		strncpy(text, "REVIVE", textlen - 1);
		break;
	      case TASK_REPLY:
		strncpy(text, "TASK_REPLY", textlen - 1);
		break;
	      case SIGACTION:
		strncpy(text, "SIGACTION", textlen - 1);
		break;
	      case SIGSUSPEND:
		strncpy(text, "SIGSUSPEND", textlen - 1);
		break;
	      case SIGPENDING:
		strncpy(text, "SIGPENDING", textlen - 1);
		break;
	      case SIGPROCMASK:
		strncpy(text, "SIGPROCMASK", textlen - 1);
		break;
	      case SIGRETURN:
		strncpy(text, "SIGRETURN", textlen - 1);
		break;
	      case REBOOT:
		strncpy(text, "REBOOT", textlen - 1);
		break;
		
	      case OK:
		strncpy(text, "OK", textlen - 1);
		break;
	      case E_BAD_DEST:
		strncpy(text, "E_BAD_DEST", textlen - 1);
		break;
	      case E_BAD_SRC:
		strncpy(text, "E_BAD_SRC", textlen - 1);
		break;
	      case E_TRY_AGAIN:
		strncpy(text, "E_TRY_AGAIN", textlen - 1);
		break;
	      case E_OVERRUN:
		strncpy(text, "E_OVERRUN", textlen - 1);
		break;
	      case E_BAD_BUF:
		strncpy(text, "E_BAD_BUF", textlen - 1);
		break;
	      case E_TASK:
		strncpy(text, "E_TASK", textlen - 1);
		break;
	      case E_NO_MESSAGE:
		strncpy(text, "E_NO_MESSAGE", textlen - 1);
		break;
	      case E_NO_PERM:
		strncpy(text, "E_NO_PERM", textlen - 1);
		break;
	      case E_BAD_FCN:
		strncpy(text, "E_BAD_FCN", textlen - 1);
		break;
	      case E_BAD_ADDR:
		strncpy(text, "E_BAD_ADDR", textlen - 1);
		break;
	      case E_BAD_PROC:
		strncpy(text, "E_BAD_PROC", textlen - 1);
		break;
	    }
	    break;
	}
    } else {
      switch (type) {
	  case EGENERIC:
	    strncpy(text, "EGENERIC", textlen - 1);
	    break;
	  case EPERM:
	    strncpy(text, "EPERM", textlen - 1);
	    break;
	  case ENOENT:
	    strncpy(text, "ENOENT", textlen - 1);
	    break;
	  case ESRCH:
	    strncpy(text, "ESRCH", textlen - 1);
	    break;
	  case EINTR:
	    strncpy(text, "EINTR", textlen - 1);
	    break;
	  case EIO:
	    strncpy(text, "EIO", textlen - 1);
	    break;
	  case ENXIO:
	    strncpy(text, "ENXIO", textlen - 1);
	    break;
	  case E2BIG:
	    strncpy(text, "E2BIG", textlen - 1);
	    break;
	  case ENOEXEC:
	    strncpy(text, "ENOEXEC", textlen - 1);
	    break;
	  case EBADF:
	    strncpy(text, "EBADF", textlen - 1);
	    break;
	  case ECHILD:
	    strncpy(text, "ECHILD", textlen - 1);
	    break;
	  case EAGAIN:
	    strncpy(text, "EAGAIN", textlen - 1);
	    break;
	  case ENOMEM:
	    strncpy(text, "ENOMEM", textlen - 1);
	    break;
	  case EACCES:
	    strncpy(text, "EACCES", textlen - 1);
	    break;
	  case EFAULT:
	    strncpy(text, "EFAULT", textlen - 1);
	    break;
	  case ENOTBLK:
	    strncpy(text, "ENOTBLK", textlen - 1);
	    break;
	  case EBUSY:
	    strncpy(text, "EBUSY", textlen - 1);
	    break;
	  case EEXIST:
	    strncpy(text, "EEXIST", textlen - 1);
	    break;
	  case EXDEV:
	    strncpy(text, "EXDEV", textlen - 1);
	    break;
	  case ENODEV:
	    strncpy(text, "ENODEV", textlen - 1);
	    break;
	  case ENOTDIR:
	    strncpy(text, "ENOTDIR", textlen - 1);
	    break;
	  case EISDIR:
	    strncpy(text, "EISDIR", textlen - 1);
	    break;
	  case EINVAL:
	    strncpy(text, "EINVAL", textlen - 1);
	    break;
	  case ENFILE:
	    strncpy(text, "ENFILE", textlen - 1);
	    break;
	  case EMFILE:
	    strncpy(text, "EMFILE", textlen - 1);
	    break;
	  case ENOTTY:
	    strncpy(text, "ENOTTY", textlen - 1);
	    break;
	  case ETXTBSY:
	    strncpy(text, "ETXTBSY", textlen - 1);
	    break;
	  case EFBIG:
	    strncpy(text, "EFBIG", textlen - 1);
	    break;
	  case ENOSPC:
	    strncpy(text, "ENOSPC", textlen - 1);
	    break;
	  case ESPIPE:
	    strncpy(text, "ESPIPE", textlen - 1);
	    break;
	  case EROFS:
	    strncpy(text, "EROFS", textlen - 1);
	    break;
	  case EMLINK:
	    strncpy(text, "EMLINK", textlen - 1);
	    break;
	  case EPIPE:
	    strncpy(text, "EPIPE", textlen - 1);
	    break;
	  case EDOM:
	    strncpy(text, "EDOM", textlen - 1);
	    break;
	  case ERANGE:
	    strncpy(text, "ERANGE", textlen - 1);
	    break;
	  case EDEADLK:
	    strncpy(text, "EDEADLK", textlen - 1);
	    break;
	  case ENAMETOOLONG:
	    strncpy(text, "ENAMETOOLONG", textlen - 1);
	    break;
	  case ENOLCK:
	    strncpy(text, "ENOLCK", textlen - 1);
	    break;
	  case ENOSYS:
	    strncpy(text, "ENOSYS", textlen - 1);
	    break;
	  case ENOTEMPTY:
	    strncpy(text, "ENOTEMPTY", textlen - 1);
	    break;

	  case EPACKSIZE:
	    strncpy(text, "EPACKSIZE", textlen - 1);
	    break;
	  case EOUTOFBUFS:
	    strncpy(text, "EOUTOFBUFS", textlen - 1);
	    break;
	  case EBADIOCTL:
	    strncpy(text, "EBADIOCTL", textlen - 1);
	    break;
	  case EBADMODE:
	    strncpy(text, "EBADMODE", textlen - 1);
	    break;
	  case EWOULDBLOCK:
	    strncpy(text, "EWOULDBLOCK", textlen - 1);
	    break;
	  case EBADDEST:
	    strncpy(text, "EBADDEST", textlen - 1);
	    break;
	  case EDSTNOTRCH:
	    strncpy(text, "EDSTNOTRCH", textlen - 1);
	    break;
	  case EISCONN:
	    strncpy(text, "EISCONN", textlen - 1);
	    break;
	  case EADDRINUSE:
	    strncpy(text, "EADDRINUSE", textlen - 1);
	    break;
	  case ECONNREFUSED:
	    strncpy(text, "ECONNREFUSED", textlen - 1);
	    break;
	  case ECONNRESET:
	    strncpy(text, "ECONNRESET", textlen - 1);
	    break;
	  case ETIMEDOUT:
	    strncpy(text, "ETIMEDOUT", textlen - 1);
	    break;
	  case EURG:
	    strncpy(text, "EURG", textlen - 1);
	    break;
	  case ENOURG:
	    strncpy(text, "ENOURG", textlen - 1);
	    break;
	  case ENOTCONN:
	    strncpy(text, "ENOTCONN", textlen - 1);
	    break;
	  case ESHUTDOWN:
	    strncpy(text, "ESHUTDOWN", textlen - 1);
	    break;
	  case ENOCONN:
	    strncpy(text, "ENOCONN", textlen - 1);
	    break;

	  case ELOCKED:
	    strncpy(text, "ELOCKED", textlen - 1);
	    break;
	  case EBADCALL:
	    strncpy(text, "EBADCALL", textlen - 1);
	    break;
	}
    }
    /*
     * If nothing has been put in the buffer, just put in the type number.
     */
    if (text[0] == '\0') {
	char *firstblank;

	sprintf(text, "%-*d", textlen - 1, type);
	if ((firstblank = strchr(text, ' ')) != 0) *firstblank = '\0';
    }
    text[textlen - 1] = '\0';       /* strncpy may not null-terminate */
}
