#include <minix/config.h>
#include <sun/signal.h>
#include <sun/syscall.h>
#include <stdio.h>
#include <string.h>

static char rcsid[] = "$Id: sunread.c,v 1.1 1996/03/20 20:49:18 paul Exp $";                                               

#define BUFSIZE 1024

char buf[BUFSIZE];
int reading;

main(argc, argv)
     int argc;
     char *argv[];
{
  int fd, length, old, o_flags;
  so_sigset_t new;
  char *prog;
  
  prog = strrchr(*argv,'/');
  if (prog == (char *)0) {
      prog = *argv;
  } else {
      prog++;
  }

  if (strcmp(prog, "sunread") == 0){
    reading = 1;
    o_flags = 0;
  } else if (strcmp(prog, "sunwrite") == 0){
    reading = 0;
    o_flags = 0x301;
  } else {
    fprintf(stderr, "%s: program basename must be sunread or sunwrite\n",
	    argv[0]);
    exit(1);
  }
  if (argc != 2){
    fprintf(stderr, "Usage: %s <SunOS filename>\n", argv[0]);
    exit(1);
  }
  
  
  
#ifdef SOLARIS
  sunsigemptyset(&new);
  sunsigaddset(&new, SO_SIGIO);
  sigaddset(&new, SO_SIGALRM);
#endif
  if ((fd = SunOS(SYS_open, argv[1], o_flags, 0666)) == -1){
    fprintf(stderr, "Can't open SunOS file: %s\n", argv[1]);
    exit(1);
  }

  do {	  
    
    if (reading) {
#ifdef SOLARIS
      SunOS(SYS_sigprocmask, SO_SIG_BLOCK, &new, NULL);
#else
      old = SunOS(SYS_sigsetmask, sigmask(SO_SIGIO) | sigmask(SO_SIGALRM));
#endif

      length = SunOS(SYS_read, fd, buf, BUFSIZE);

#ifdef SOLARIS
      SunOS(SYS_sigprocmask, SO_SIG_UNBLOCK, &new, NULL);
#else
      SunOS(SYS_sigsetmask, old);
#endif      

      write(1, buf, length);
    } else {
      length = read(0, buf, BUFSIZE);
#ifdef SOLARIS
      SunOS(SYS_sigprocmask, SO_SIG_BLOCK, &new, NULL);
#else
      old = SunOS(SYS_sigsetmask, sigmask(SO_SIGIO) | sigmask(SO_SIGALRM));
#endif

      SunOS(SYS_write, fd, buf, length);

#ifdef SOLARIS
      SunOS(SYS_sigprocmask, SO_SIG_UNBLOCK, &new, NULL);
#else
      SunOS(SYS_sigsetmask, old);
#endif      
    }
  } while (length != 0);
  SunOS(SYS_close, fd);
}
