#include <minix/config.h>
#include <minix/const.h>
#if (CHIP == SPARC)

! $Id: copySUN.s,v 1.1 1996/03/20 21:27:37 paul Exp $
!****************************************************************************
!
!     C O P Y _ S P . S                                       M I N I X
!
!     Basic fast copy routines used by the kernel 
!****************************************************************************
!
! Contents:
!
!   real_flipclicks   exchange two block of clicks
!   real_zeroclicks   zero a block of clicks
!   real_copyclicks   copy a block of clicks
!   real_phys_copy    copy a block of bytes
!
!============================================================================
!
!****************************************************************************

           .global  real_flipclicks
           .global  real_zeroclicks
           .global  real_copyclicks
           .global  real_phys_copy


!****************************************************************************
!
!          r e a l _ f l i p c l i c k s
!
!          exchange to blocks of n clicks
!****************************************************************************
!
! Input:   
!                 %i2   - number of clicks to copy
!                 %i1   - physical click address 2
!                 %i0   - physical click address 1
!
!****************************************************************************


real_flipclicks:
	save %sp,-96,%sp
	sll %i0,CLICK_SHIFT,%l0		  ! abs. source address
	sll %i1,CLICK_SHIFT,%l1		  ! abs. destination address
	sll %i2,CLICK_SHIFT-3,%l2		  ! length in double words
flip00:
	tst %l2
	be flip01
	nop
	sub %l2,1,%l2
	ldd [%l0],%l4
	ldd [%l1],%l6
	std %l4,[%l1]
	std %l6,[%l0]
	add %l0,8,%l0
	add %l1,8,%l1
	ba flip00
	nop
flip01:
	ret
	restore
	
	   

!****************************************************************************
!
!          r e a l _ z e r o c l i c k s
!
!          zero n clicks from source click to destination click address
!****************************************************************************
!
! Input:   
!                 %i1   - number of clicks to zero
!                 %i0   - physical destination click address
!
!****************************************************************************


real_zeroclicks:
	save %sp,-96,%sp
	sll %i0,CLICK_SHIFT,%l0	  ! abs. source address
	sll %i1,CLICK_SHIFT-3,%l1 ! number of double words to zero
	mov %g0,%g1		  ! get two 0 registers
zero00:
	tst %l1
	be zero01
	nop
	sub %l1,1,%l1
	std %g0,[%l0]
	add %l0,8,%l0
	ba zero00
	nop
zero01:
	ret
	restore
	

!****************************************************************************
!
!          r e a l _ c o p y c l i c k s
!
!          copy n clicks from source click to destination click address
!****************************************************************************
!
! Input:
!                 %i2   - number of clicks to copy
!                 %i1   - physical destination click address
!                 %i0    - physical source click address
!
!
!****************************************************************************

real_copyclicks:
	save %sp,-96,%sp
	sll %i0,CLICK_SHIFT,%l0	  ! abs. source address
	sll %i1,CLICK_SHIFT,%l1	  ! abs. destination address
	sll %i2,CLICK_SHIFT-3,%l2 ! length in double words
copy00:
	tst %l2
	be copy01
	nop
	sub %l2,1,%l2
	ldd [%l0],%l4
	std %l4,[%l1]
	add %l0,8,%l0
	add %l1,8,%l1
	ba copy00
	nop
copy01:
	ret
	restore
        


!****************************************************************************
!
!          r e a l _ p h y s _ c o p y
!
!          copy n bytes from source to destination address
!****************************************************************************
!
! Input:   
!                 %i2   - number of bytes to copy
!                 %i1   - physical destination address ptr.
!                 %i0   - physical source address ptr.
!
! phys_copy is designed to determine which load and store instruction will
! perform the copy in the least. This decision depends on whether the source
! and destination are 8-byte aligned (use ldd), 4-byte aligned (use ld), 
! 2-byte aligned (use lduh) or not aligned (use ldub). It may be necessary
! to copy several bytes (using ldub) in order to make both the source and
! destination address aligned. eg. src = 6 dest =  798 can be be copied in
! lots of 8 as long as the first 2 bytes are copied by the byte.
!
!****************************************************************************

real_phys_copy:
	save %sp,-96,%sp
	mov %i0,%l0
	mov %i1,%l1
	mov %i2,%l2
	xor %l0,%l1,%l3		/* find out how aligned src and dest are */
	andcc %l3,1,%g0
	bne pc1			/* not aligned */
        nop
        andcc %l3,2,%g0
        bne pc2			/* 2-byte */
	nop
	andcc %l3,4,%g0
	bne pc4			/* 4-byte */
	nop

	/* else copy in multiples of 8 bytes */
pc8:
	sub %l0,1,%l3
	and %l3,7,%l3
	call pcbytes		/* copy any initial bytes */
	xor %l3,7,%l3
	ba pc8_1
	nop
	
pc8_2:
	ldd [%l0],%l4		/* copy in groups of 8 */
	std %l4,[%l1]
	add %l0,8,%l0
	add %l1,8,%l1
	sub %l2,8,%l2
pc8_1:
	cmp %l2,8
	bge pc8_2
	nop
	call pcbytes		/* finish off any extra bytes */
	mov 8,%l3		/* (copy upto 8 bytes) */
	ba pcexit
	nop


	/* copy in lots of 4 bytes */	
pc4:
	sub %l0,1,%l3
	and %l3,3,%l3
	call pcbytes		/* initial byte copying */
	xor %l3,3,%l3
	ba pc4_1
	nop
	
pc4_2:
	ld [%l0],%l4		/* copy in groups of 4 */
	st %l4,[%l1]
	add %l0,4,%l0
	add %l1,4,%l1
	sub %l2,4,%l2
pc4_1:
	cmp %l2,4
	bge pc4_2
	nop
	call pcbytes		/* finish off any extra bytes */
	mov 4,%l3		/* (copy upto 4 bytes) */
	ba pcexit
	nop

	/* copy in groups of 2 */
pc2:
	sub %l0,1,%l3
	and %l3,1,%l3
	call pcbytes		/* initial alignment */
	xor %l3,1,%l3
	ba pc2_1
	nop
	

pc2_2:
	lduh [%l0],%l4		/* copy 2 bytes at a time */
	sth %l4,[%l1]
	add %l0,2,%l0
	add %l1,2,%l1
	sub %l2,2,%l2
pc2_1:
	cmp %l2,2
	bge pc2_2
	nop
	call pcbytes		/* finish off any extra bytes */
	mov 2,%l3		/* (copy upto 2 bytes) */
	ba pcexit
	nop
	
	/* copying byte by byte */
pc1:	call pcbytes
	mov -1,%l3
	ba pcexit
	nop
	
	/* a local function for copying byte by byte */
pcbytes:			/* leaf routine */
	tst %l2
	be pcbytes_1
	nop
	tst %l3
	be pcbytes_1
	nop
	ldub [%l0],%l4
	stb %l4,[%l1]
	add %l0,1,%l0
	add %l1,1,%l1
	sub %l2,1,%l2
	ba pcbytes
	sub %l3,1,%l3
pcbytes_1:
	retl
	nop
	
pcexit:
	ret
	restore


#endif
