#include "kernel.h"
#include "logging.h"
#include <sun/syscall.h>
#include "proc.h"

static char rcsid[] = "$Id: logging.c,v 1.1 1996/03/20 21:27:44 paul Exp $";

#define LBUFF_SIZE 8192

static char log_buffer[LBUFF_SIZE];
static int buff_pos = 0;

int logging_enabled = 0;
static int enable_check = 0;

FORWARD _PROTOTYPE( void write_to_log, (char *buffer, int buff_len)       );
FORWARD _PROTOTYPE( void log_flush, (void)                                );


PUBLIC void
log_init()
{
    int fd;

    if ((fd = SunOS(SYS_dup, LOGGING_FD)) != -1) {
        SunOS(SYS_close, fd);
	logging_enabled = 1;
    }
}


PRIVATE void
write_to_log(buffer, buff_len)
char *buffer;
int buff_len;
{
    if (!enable_check) {
	log_init();
    }

    if (!logging_enabled || buff_len < 1 || buff_len > LBUFF_SIZE) return;

    if (buff_pos + buff_len > LBUFF_SIZE) {
	log_flush();
    }
    memcpy(log_buffer + buff_pos, buffer, buff_len);
    buff_pos += buff_len;
}


PRIVATE void
log_flush()
{
    if (logging_enabled && buff_pos > 0) {
	SunOS(SYS_write, LOGGING_FD, log_buffer, buff_pos);
	buff_pos = 0;
    }
}


PUBLIC void
event_log(event, p, other_stn, buff, buff_len)
int event;
struct proc *p;
int other_stn;
void *buff;
int buff_len;
{
    struct ev_record ev;

    if (p->p_stn == INVALID_STN) return;

    if (event == EV_TTY_INPUT) {
	log_flush();
    }

    ev.e_event = event;
    ev.e_pnr = p->p_nr;
    ev.e_stn = p->p_stn;
    ev.e_other_stn = other_stn;
    SunOS(SYS_gettimeofday, &ev.e_secs, 0);
    ev.e_bufflen = buff_len;
    write_to_log((char *) &ev, sizeof(ev));
    write_to_log(buff, buff_len);
}
    

PUBLIC int
next_stn()
{
    static int stn = 0;

    if (++stn < 0) {
	stn = 0;
    }
    return stn;
}
