/* This file contains the assembly language code for handling SunOS signals
 * and hence the saving and restoring of Minix contexts. Also included are a
 * few signal related calls (eg. lock and unlock) as well as a special function
 * 'SunOS' for performing SunOS system calls.
 */
/* $Id: mpxSUN.s,v 1.1 1996/03/20 21:27:50 paul Exp $ */

#include <minix/config.h>
#if (CHIP == SPARC)


#define _ASM
#ifdef SOLARIS
/*
 * This section contains the Solaris context switching code
 */

#include </usr/include/sys/trap.h>
#include <sun/syscall.h>
#include <sun/signal.h>
#include "sunsconst.h"

	.global SunOS,SunOSsig,restart,restart2,s_call
	.global lock,unlock,restore,test_and_set,idle_task, errno
        .global mpxSP_start, mpxSP_end

/*===========================================================================*
 *                              SunOSsig                                     * 
 *===========================================================================*/
 
/* This function is the handler for most of Solaris's signals. Parts of the 
 * 'ucontext' structure that are pushed onto the kernel (signal) stack by
 * Solaris are copied into the Minix proc table entry of the currently executing 
 * Minix process. The array 'vectors' is used to determine which function
 * within the Minix kernel should then take responsibilty for the signal.
 * Finally, the context of the current (or possibly new) process is restored.
 */
 

mpxSP_start:	/* DO NOT MOVE THIS LABEL */
SunOSsig:
	/* Save the process's In and Local registers on the stack */
	save %sp,-96,%sp

	call entering_kernel
	nop

	/* Get the Solaris signal number and a pointer to the process's context */
	mov %i0, %o0
	mov %i2, %o2

	/* Put the REAL stack pointer into ss_sp */
	ld [%o2 + o6],%l0
	st %l0, [%o2 + sp]

	/* Get a pointer to the current proc table entry */	
	set proc_ptr,%l0
	ld [%l0],%l0

	/* Save the important parts of the ucontext structure into the
	 * current proc table entry. The current signal state is also stored,
	 * but not used.
	 */
	mov %o2,%l1 
	mov %l0,%l2
	call rcopy
	mov 29,%l3
	
	/* Save the Ins and Locals that were pushed onto the stack
	 * by the initial save instruction.
	 */
	mov %fp,%l1
	call rcopy
	mov 16,%l3

	/* We now look at the appropriate 'vectors' entry to find a function
	 * to call.
	 */	
in_kernel1:
	set vectors,%g1
	sll %o0,2,%g2
	ld [%g1 + %g2],%g1
	jmpl %g1,%o7
	nop
	
	/* possibly run a new process */
	call lock_pick_proc
	nop
	set proc_ptr,%l0
	ld [%l0],%l0

#ifdef notdef
	/* Nested signal code */
	set k_reenter,%l1
	ldsb [%l1], %l2
	sub %l2,1,%l2
	stb %l2,[%l1]
	tst %l2
	bge in_kernel2
	nop
#endif
	mov 1,%l7   /* we do want leaving_kernel called */
	 
restart3:
	/* At this point, we are ready to restore the context of a Minix
	 * process. We have either just handled a Solaris signal or have come here
	 * via a SIGUSR2 signal. */
	 
	mov %i0, %o0
	mov %i2, %o2 

	/* Restore the sp, pc, npc etc. We also set the signal mask back to 0,
	 * regardless of what it was before.
	 */

	ld [%o2 + 28], %o3
	ld [%o2 + 32], %o4
	mov %o2,%l2
	add %l2, 4, %l2
	mov %l0,%l1
	add %l1, 4, %l1
	call rcopy
	mov 28,%l3

	ld [%o2], %l0
	or %l0,1,%l0
	st %l0,[%o2]
	st %g0,[%o2 + 8]
	st %g0,[%o2 + 12]
	st %g0,[%o2 + 16]
	st %g0,[%o2 + 20]
	st %o3,[%o2 + 28]	
	st %o4,[%o2 + 32]	
	
	/* Restore the Ins and Locals */
	mov %fp,%l2
	call rcopy
	mov 16,%l3

	/* Put ss_sp back into o6 */

	ld [%o2 + sp],%l0
	st %l0, [%o2 + o6]
	
	/*
	 * Have all of the volatile registers on the stack - sort out
	 * protection, then restore those registers.
	 */

	cmp %l7,%g0
	beq skip_call
	nop

	call leaving_kernel
	nop

skip_call:

	/* Finally, execute a special Solairs system call to return from a
	 * signal.
	 */
in_kernel2:
	restore
	mov SYS_context,%g1
	mov 1,%o0
	mov %o2, %o1		
	ta ST_SYSCALL
	nop
	nop
	nop


/*===========================================================================*
 *                              restart                                      * 
 *===========================================================================*/

/* This is the special handler used by the Solaris SIGUSR2 signal so
 * that it is possible to give a process a new context without saving
 * its old context. It is called mainly from within a Minix program's
 * signal handling code. %i5 points to the context to restore.
 */

restart2:	
	save %sp,-96,%sp
	ld [%i2 + 104], %l0
	mov %g0,%l7    /* trampolining - we don't want leaving_kernel called */
	ba restart3	
	nop
	
/* The 'restart' function is called (only once) from 'main.c' in order
 * to get the the first process running. A Solaris SIGUSR2 signal is
 * sent with %o5 pointing to the process to be started. 
 */
 
restart:
	set k_reenter,%o0
 	mov 0,%o1               /* Set to zero while disabled */
	stb %o1,[%o0]
	mov SYS_getpid,%g1	/* Find out where to send the signal */
	ta ST_SYSCALL
	set proc_ptr,%o1
	ld [%o1],%o5		/* Get the first proc table entry */
	mov SYS_kill,%g1
	mov SO_SIGUSR2,%o1
	ta ST_SYSCALL		/* Send the signal */
	retl
	nop			/* Should never happen */

mpxSP_end:	/* DO NOT MOVE THIS LABEL */

/*===========================================================================*
 *                              s_call                                       * 
 *===========================================================================*/

/* All messages pass through this point. A process can send a message
 * by placing the parameters on the stack and then sending a Solaris
 * SIGUSR1.
 */
s_call:
	save %sp,-256,%sp
	set proc_ptr,%l0
	ld [%l0],%l0

	ld [%l0 + sp], %l1
	add %l1,92,%o0
	call sys_call
	nop
	
	st %o0,[%l0 + o0]	/* return the result of the send/receive */
	ret
	restore

/*===========================================================================*
 *                              rcopy	                                     * 
 *===========================================================================*/
 
/* A small procedure used for copy memory.
 * %l1 is the source address,
 * %l2 is destination address,
 * %l3 is number of words to copy.
 */
rcopy:
	cmp %g0,%l3
	be rcopy00
	nop
	ld [%l1],%l4
	st %l4,[%l2]
	add %l1,4,%l1
	add %l2,4,%l2
	ba rcopy
	sub %l3,1,%l3
rcopy00:
	retl
	nop

/*===========================================================================*
 *                              SunOS	                                     * 
 *===========================================================================*/	

/* This function is used every time a kernel task wishes to use a 
 * Solaris system call. The format of a call is:
 *	SunOS(SYS_xxxxx, parameter, ..., ...);
 * The list of system calls is given in <sun/syscall.h>
 */
SunOS:
	mov %o0,%g1
	mov %o1,%o0
	mov %o2,%o1
	mov %o3,%o2
	mov %o4,%o3
	mov %o5,%o4
	t ST_SYSCALL
	bgeu noerr
	nop
	set errno,%g1
	st %o0,[%g1]
	mov -1,%o0

noerr:	retl
	nop
	

/*===========================================================================*
 *                              lock etc                                     * 
 *===========================================================================*/

/* void lock(so_sigset_t savesigmask)
	Blocks all asynchronous Solaris signals ie. SIGALRM, SIGIO */
	
lock:
	save %sp,-96,%sp
	mov  SYS_sigprocmask,%o0
	mov  SO_SIG_SETMASK, %o1
        set  sigs,%o2
	mov  %i0,%o3
	call SunOS
	nop
	ret
	restore

/* void unlock(void) Unblocks all Solaris signals */
	.seg "bss"
zeromask:	.skip SO_SIGSET_BYTES
	.seg "text"
unlock:
	save %sp,-96,%sp
	mov  SYS_sigprocmask,%o0
	mov  SO_SIG_SETMASK, %o1
	set  zeromask,%o2
	clr  %o3
	call SunOS
	nop
	ret
	restore

/* void restore(so_sigset_t restoremask)  Restore a given signal state */
restore:
	save %sp,-96,%sp
	mov SYS_sigprocmask,%o0
	mov SO_SIG_SETMASK, %o1
	mov %i0,%o2
	clr %o3
	call SunOS
	nop
	ret
	restore

/* Used for atomicity */
test_and_set:
	ldstub [%o0],%o0
	retl
	nop
	
/*===========================================================================*
 *                              idle_task                                    * 
 *===========================================================================*/

/* Does nothing but sleep */

idle_task:
	save %sp,-96,%sp
it2:	mov SYS_signal,%o0
	set (SIGPAUSE | 1),%o1
	call SunOS
	nop
	ba it2
	nop

#endif /* SOLARIS */

#endif /* CHIP == SPARC */
