#include <minix/config.h>
#include <minix/const.h>
#include <sun/os.h>
#include "const.h"

#if (CHIP == SPARC)

! This is the C run-time start-off routine.

! $Id: startSUN.s,v 1.1 1996/03/20 21:27:56 paul Exp $

! public labels
	.global sizes, getksp, getsp, mem_bytes
	.global k_stack, savedsp

start:
	set k_stack,%l0
	set 0xfffffff8,%l1
	and %l0,%l1,%sp

	set CLICK_SIZE-1,%l0	! Align %sp on the next lowest click
	not %l0			! boundary (for protection reasons)
	and %sp,%l0,%sp
	sub %sp,8,%sp           ! it now points to the last double word in a
				! click

	sub %sp,96,%sp          ! leave space for a stack frame
	set savedsp,%l0
	st %sp,[%l0]
	
	/*
	 * We must determine whether this is running under SunOS or Solaris.
	 * Since this is within the kernel, we can simply look at the compile
	 * time definitions.
	 */

	set start,%l0
	set code_base,%l1
	st %l0,[%l1]
	call main
	nop

L0:	ba L0
	nop

/*
 * Get the kernel stack pointer
 */

getksp:
	set savedsp,%o0
	ld [%o0],%o0
	retl
	nop
_getsp:
getsp:
	mov %sp,%o0
	and 0xfffffff8, %o0, %o0
	retl
	nop
	
	.seg "data"
	
! tools/build/build.c assumes that _sizes and _mem_bytes are contiguous
sizes:
	.word 0,0,0,0

mem_bytes:
	.word 0

/*
 * These 2 extra 'shorts' are filled with the protection and debug levels
 */
extras:	.word 0

/*
 * What is the operating system type
 */

savedsp: .word 0

	.seg "bss"
	.skip K_STACK_BYTES + CLICK_SIZE -1 	! leave click aligned space
	.align 8
k_stack:

#endif
