/* This file contains code to handle SunOS's signals. Signals are either passed
 * on to the currently executing Minix process (eg. SIGSEGV), completely
 * ignored (eg. SIGINT) or can cause Minix to shutdown (eg. SIGTERM).
 * If a caught signal occurs within the kernel or one of the servers, Minix is
 * shutdown after displaying some debugging information.
 */

#include "kernel.h"
#include "proc.h"
#include <sun/signal.h>
#include <sun/syscall.h>

static char rcsid[] = "$Id: sunexception.c,v 1.1 1996/03/20 21:28:02 paul Exp $";

/* Given a SunOS signal number, this table is used to determine what to do with
 * it. If the entry is a '0' the signal is ignored, otherwise it is a Minix
 * signal number.
 */

int signum[_SIGRTMAX + 1] = {
    0, /* not used */
    0, /* SO_SIGHUP  */
    0, /* SO_SIGINT  */
    0, /* SO_SIGQUIT */
    4, /* SO_SIGILL */
    5, /* SO_SIGTRAP */
    6, /* SO_SIGABRT */
    0, /* SO_SIGEMT  */
    8, /* SO_SIGFPE  */
    9, /* SO_SIGKILL */
    11, /* SO_SIGBUS  */
    11, /* SO_SIGSEGV */
    11, /* SO_SIGSYS  */
  /* All zero from here */
};
 

/*===========================================================================*
 *				exception				     *
 *===========================================================================*/	
PUBLIC void exception(sig, siginf, scp)
int sig;
void *siginf;
struct stackframe_s *scp;
{
/* The procedure is called by the SunOS signal handler. The signal is either
 * passed on, ignored or can cause a shutdown.
 */

    int mx_sig = signum[sig];

    if (sig == SO_SIGTERM){
  	printf("\nMinix terminated\n");
  	SunOS(SYS_exit, 0);
    }
    
    /* ignore some signals */
    if (mx_sig == 0) return;
    
    /* if a user process is currently executing, send it a signal */
    if (k_reenter == 0 && isuserp(proc_ptr)){
  	cause_sig(proc_number(proc_ptr), mx_sig);
	return;
    }
    
    /* A signal within the kernel causes a shutdown */
    printf("\nSunOS signal number %d received within kernel\n", sig);
    printf("PC = 0x%x, task = %d", 
	   proc_ptr->p_reg.pc, proc_number(proc_ptr));
    printf("\n");
    panic("Signal within kernel", NO_NUM);
}

/*===========================================================================*
 *				do_dump					     *
 *===========================================================================*/	
PUBLIC void do_dump()
{
/* display debugging information. This is called from within panic */
    
    int count;
    
    printf("\nSP = %x PSW = %x", proc_ptr->p_reg.sp, proc_ptr->p_reg.psw);
    for (count = 0; count < 32; count++){
  	if (count % 4 == 0) printf("\n");
#if (CHIP == SPARC)	
  	printf("r%02d = %08X ",count, proc_ptr->p_reg.wbuf[count]);
#endif
    }
    printf("\n\n");
    p_dmp();
    map_dmp();
}


