/*
 * fclose.c - flush a stream and close the file
 */
/* $Header: /home/paul/CVS/minix1.7/src/lib/stdio/fclose.c,v 1.1.1.1 1995/11/10 00:24:34 paul Exp $ */

#include	<stdio.h>
#include	<stdlib.h>
#include	"loc_incl.h"

int _close(int d);

int
fclose(FILE *fp)
{
	register int i, retval = 0;

	for (i=0; i<FOPEN_MAX; i++)
		if (fp == __iotab[i]) {
			__iotab[i] = 0;
			break;
		}
	if (i >= FOPEN_MAX)
		return EOF;
	if (fflush(fp)) retval = EOF;
	if (_close(fileno(fp))) retval = EOF;
	if ( io_testflag(fp,_IOMYBUF) && fp->_buf )
		free((void *)fp->_buf);
	if (fp != stdin && fp != stdout && fp != stderr)
		free((void *)fp);
	return retval;
}
