/*
 * perror.c - print an error message on the standard error output
 */
/* $Header: /home/paul/CVS/minix1.7/src/lib/stdio/perror.c,v 1.1.1.1 1995/11/10 00:24:36 paul Exp $ */

#if	defined(_POSIX_SOURCE)
#include	<sys/types.h>
#endif
#include	<stdio.h>
#include	<errno.h>
#include	<stdio.h>
#include	<string.h>
#include	"loc_incl.h"

ssize_t _write(int d, const char *buf, size_t nbytes);

void
perror(const char *s)
{
	char *p;
	int fd;

	fd = fileno(stderr);
	fflush(stdout);
	fflush(stderr);
	if (s && *s) {
		_write(fd, s, strlen(s));
		_write(fd, ": ", 2);
	}
	p = strerror(errno);
	_write(fd, p, strlen(p));
	_write(fd, "\n", 1);
}
