/* Minix signals come through this point and the user process's vector table
 * is examined to see which function is to be called. The process's old 
 * context (before the signal) is saved on the stack. A SunOS SIGUSR2 signal
 * must be sent in order to restore this old context.
 */
/* $Id: catch.s,v 1.1 1996/03/20 21:07:33 paul Exp $ */

#define _ASM
#include <minix/config.h>
#include <sun/signal.h>

#include <sun/os.h>
#include <sun/syscall.h>
#include <sys/trap.h>

	.global begsig
begsig:
	ld [%sp + 64],%o0
	sll %o0,2,%o0
	sub %o0,4,%o0
	set __vectab,%o1	/* look in signal vector table for function */
	ld [%o0 + %o1],%g1
	tst %g1
	be nosig		/* is there a function set up? */
	nop
	
	jmpl %g1,%o7            /* call it */
	nop
nosig:	
	mov SOL_getpid,%g1
	ta 8
	add %sp,68,%o5	
	mov SOL_kill,%g1
	mov SOL_SIGUSR2,%o1	/* return to the kernel, restoring our old */
	ta 8			/* context. */


