/* $Id: sndrec.s,v 1.1 1996/03/20 21:07:45 paul Exp $ */
/* This code is included in Minix programs that send messages. The send/rec
 * parameters are put onto the stack and a SunOS SIGUSR1 signal is sent to
 * the currently executing SunOS process (i.e. smx). The ALARM and SIGIO signals
 * are disabled before the signal is sent, due to a race condition that seems
 * to occur even if these signals are disabled by the signal mask applied by 
 * SunOS before a signal is delivered.
 */

#include <minix/config.h>

#define _ASM
#include <sun/syscall.h>
#include <sun/signal.h>

#include <sys/trap.h>

#include <sun/os.h>
	
	.global _send, _receive, _sendrec	
	
	SEND 		= 1
	RECEIVE 	= 2
	BOTH 		= 3

_send:
	save %sp,-128,%sp
	ba L0
	mov SEND,%l0

_receive:
	save %sp,-128,%sp
	ba L0
	mov RECEIVE,%l0

_sendrec:
	save %sp,-128,%sp
	mov BOTH,%l0

L0:
	st %l0,[%sp + 92]	/* store parameters on the stack */
	st %i0,[%sp + 96]
	st %i1,[%sp + 100]

	/*
 	 * Send a signal
	 */
	mov SOL_sigprocmask,%g1
	mov SOL_SIG_SETMASK, %o0
        set sigoff,%o1
	mov %g0,%o2
	ta 8

	mov SOL_getpid,%g1
	ta 8			/* get our SunOS pid */
	mov SOL_kill,%g1
	mov SOL_SIGUSR1,%o1
	ta 8			/* send a SIGUSR1 signal */
	mov %o0,%i0

	mov SOL_sigprocmask,%g1
	mov SOL_SIG_SETMASK, %o0
        set sigon,%o1
	mov %g0,%o2
	ta 8
	nop

	ret
	restore

	.seg "data"

sigoff:	.word 0x402000,0,0,0
sigon:	.word 0,0,0,0
