static char rcsid[] = "$Id: relocate.c,v 1.1 1996/03/20 21:22:24 paul Exp $";

/* relocate.c */

#include "mm.h"
#include <minix/callnr.h>
#include <signal.h>
#include "mproc.h"
#include "param.h"


#define BUF_ELEMENTS 128

/* codes for identifier which segment to relocate */
/* same for both type of Sun */
#define	N_UNDF	0x0		/* undefined */
#define	N_ABS	0x2		/* absolute */
#define	N_TEXT	0x4		/* text */
#define	N_DATA	0x6		/* data */
#define	N_BSS	0x8		/* bss */
#define	N_COMM	0x12		/* common (internal to ld) */
#define	N_FN	0x1e		/* file name symbol */
#define	N_EXT	01		/* external bit, or'ed in */
#define	N_TYPE	0x1e		/* mask for all the type bits */

#if (CHIP == SPARC)
/* This file contains the code for relocation SPARC executable files */


#define  MASK(n) ((1<<(n))-1)

/* the various types of relocation that a SPARC program may contain */
enum reloc_type
{
    RELOC_8,	RELOC_16,	RELOC_32,	/* simplest relocs    */
    RELOC_DISP8,	RELOC_DISP16,	RELOC_DISP32,  /* Disp's (pc-rel)    */
    RELOC_WDISP30,	RELOC_WDISP22,		       /* SR word disp's     */
    RELOC_HI22,	RELOC_22,			       /* SR 22-bit relocs   */
    RELOC_13,	RELOC_LO10,			       /* SR 13&10-bit relocs*/
    RELOC_SFA_BASE,	RELOC_SFA_OFF13,	       /* SR S.F.A. relocs   */
    RELOC_BASE10,	RELOC_BASE13,	RELOC_BASE22,  /* base_relative pic */
    RELOC_PC10,	RELOC_PC22,			       /* special pc-rel pic*/
    RELOC_JMP_TBL,				       /* jmp_tbl_rel in pic */
    RELOC_SEGOFF16,				       /* ShLib offset-in-seg*/
    RELOC_GLOB_DAT, RELOC_JMP_SLOT, RELOC_RELATIVE,    /* rtld relocs        */
};

/* This is the structure of each relocation item in a SPARC executable */
struct ris
{
    unsigned long int r_address;       /* relocation addr (offset in segment)*/
    unsigned int      r_index  :24;    /* segment index or symbol index      */
    unsigned int      r_extern : 1;    /* if F, r_index==SEG#; if T, SYM idx */
    int			       : 2;    /* <unused>		             */
    enum reloc_type   r_type   : 5;    /* type of relocation to perform      */
    long int	      r_addend;	       /* addend for relocation value	     */
};


FORWARD _PROTOTYPE( void upd_reloc, (struct ris *rp, long *where, long what));


/*===========================================================================*
 *				upd_reloc				     *
 *===========================================================================*/
PRIVATE void
upd_reloc(rp, where, what)
struct ris *rp;
long *where;
long what;
{
/* This code is responsible for performing the actual relocations. 'rp' is the
 * relocation info entry from the load file, 'where' is the destination of the
 * change, 'what' is either the value to be inserted into 'where', or a 
 * displacement from 'where'.
 */
 
    switch (rp->r_type) {
    case RELOC_RELATIVE:
	what += *where << (32-22);
	*where = (*where & ~MASK(22)) | ((what >> (32-22)) & MASK(22));
	where++;
	what += (*where & MASK(10));
	*where = (*where & ~MASK(10)) | (what & MASK(10));
	break;

    case RELOC_8:
    case RELOC_DISP8:
	what += *where & MASK(8);
	*where = what;
	break;

    case RELOC_LO10:
    case RELOC_BASE10:
	what += *where & MASK(10);
	*where = (*where & ~MASK(10)) | (what & MASK(10));
	break;

    case RELOC_BASE13:
    case RELOC_13:
	what += *where & MASK(13);
	*where = (*where & ~MASK(13)) | (what & MASK(13));
	break;

    case RELOC_16:
    case RELOC_DISP16:
	what += *where & MASK(16);
	*(short *)where = what;
	break;
	
    case RELOC_22:
    case RELOC_BASE22:
	what += *where & MASK(22);
	*where = (*where & ~MASK(22)) | (what & MASK(22));
	break;

    case RELOC_HI22:
	what += (*where<<32-22) & MASK(22);
	*where = (*where & ~MASK(22)) | ((what>>(32-22)) & MASK(22));
	break;

    case RELOC_WDISP22:
	what += *where & MASK(22);
	what >>= 2;
	*where = (*where & ~MASK(22)) | (what & MASK(22));
	break;
		
    case RELOC_WDISP30:
	what += *where & MASK(30);
	what >>= 2;
	*where = (*where & ~MASK(30)) | (what&MASK(30));
	break;

    case RELOC_32:
    case RELOC_GLOB_DAT:
    case RELOC_DISP32:
	what += *where;
	*where = what;
	break;

    default:
	break;
    }
}


/*===========================================================================*
 *				relocate				     *
 *===========================================================================*/
PUBLIC int relocate(fd, base, seg_size, size, t_size)
int fd;				/* file descriptor to read from */
phys_bytes base;		/* base of segment to be relocated */
long seg_size;			/* size of this segment (for error checking) */
long size;			/* size of reloc information */
long t_size;			/* size of text from exec file */
{
    static struct ris buf[BUF_ELEMENTS];
    register n;
    register struct ris *rp;
    register phys_bytes off;
    register phys_bytes adr;
    register struct mproc *rmp = mp;
    long dest_value, offset;
    int reloc_num = 0;
  
    /* how many relocation entries are there? */
    size /= sizeof(struct ris);
  
    while (size != 0){
  	/* how many entries can we fit into 'buf' */
	n = (sizeof(buf)/sizeof(struct ris));
	n = MIN(n, size);
	
	/* read as many entries as possible or as many as there are left */
	if (n * sizeof(struct ris) != read(fd, buf, n * sizeof(struct ris))) {
	    printf("MM: relocate: read failed\n");
	}
  	size -= n;
	rp = buf;
	do {

	    /* check for relocations that rely on symbols */
	    if (rp->r_extern == 1){
		printf("\nUndefined symbols still exist in file\n");
		return(-1);
	    }
	    /* decide which segment contains the destination of the relocation */
	    switch(rp->r_index)
	    {
	    case N_UNDF:
		printf("\nUndefined symbols still exist in file\n");
		return(-1);
		
	    case N_ABS:
		printf("AN N_ABS reloc!\n");
		offset = 0;
		break;

	    case N_TEXT:			/* rel. to base of text */
		offset = (long)rmp->mp_seg[T].mem_phys << CLICK_SHIFT;
		break;

	    case N_BSS:
	    case N_DATA:			/* rel. to base of data */
		offset = (long)((rmp->mp_seg[D].mem_phys << CLICK_SHIFT)
				- t_size);
		break;
	    default:
		printf("\nRelocation %d invalid: unknown index %d\n",
		       reloc_num, rp->r_index);
		panic("Relocation error", NO_NUM);
		return(-1);
	    }
	    /* decide how the destination should be referenced (rel. or abs.)*/
	    switch(rp->r_type)
	    {
	    case RELOC_DISP8:
	    case RELOC_DISP16:
	    case RELOC_DISP32:
	    case RELOC_WDISP30:
	    case RELOC_WDISP22:
		dest_value = rp->r_addend;
		break;
	    default:
		dest_value = offset + rp->r_addend;
		break;
	    }
	    
	    if ((rp->r_address < 0) || (rp->r_address > seg_size)){
		printf("\nInvalid relocation: %x outside range\n",
		       rp->r_address);
		return(-1);			
	    }
	    
	    /* perform the relocation */
	    upd_reloc(rp, (long *)(rp->r_address + base), dest_value); 
	    reloc_num++;
	} while (n--, rp++, n != 0 );
    }
    return(0);
}

#endif
