#!/bin/bash
# The "continue N" command, continuing at the Nth level loop.

for outer in I II III IV V           # outer loop
do
  echo; echo -n "Group $outer: "

  for inner in 1 2 3 4 5 6 7 8 9 10  # inner loop
  do

    if [ "$inner" -eq 7 ]
    then
      continue 2  # Continue at loop on 2nd level, that is "outer loop".
                  # Replace above line with a simple "continue"
                  # to see normal loop behavior.
    fi  

    echo -n "$inner "  # 8 9 10 will never echo.
  done  

done

echo; echo

# Exercise:
# Come up with a meaningful use for "continue N" in a script.

exit 0
