/*
    yamm, Yet Another Micro Monitor
    comp_dim.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "define.h"
#include "extern.h"

int compare_size( a, b ) /* "size" is data + text + stack */
struct pst_status *a,*b;
{
#if !defined(linux)
	long size_a = a->pst_dsize + a->pst_tsize + a->pst_ssize;
	long size_b = b->pst_dsize + b->pst_tsize + b->pst_ssize;
#else
	long size_a = a->pst_vsize;
	long size_b = b->pst_vsize;
#endif /* !linux */

	if ( invert )
		return ( size_a < size_b ? -1 : size_a == size_b ? 0 : 1 );
	else
		return ( size_a < size_b ? 1 : size_a == size_b ? 0 : -1 );
		
}

int compare_ressize( a, b ) /* "ressize" is resident set size */
struct pst_status *a,*b;
{
	long size_a = a->pst_rssize;
	long size_b = b->pst_rssize;

	if ( invert )
		return ( size_a < size_b ? -1 : size_a == size_b ? 0 : 1 );
	else
		return ( size_a < size_b ? 1 : size_a == size_b ? 0 : -1 );
		
}
