/*
    yamm, Yet Another Micro Monitor
    get_status.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/time.h>
#include "define.h"
#include "extern.h"

#define NUM_ELEM 6

#if !defined(linux)

struct _status {
	long def;
	char car;
	int num;
}; 

static struct _status ret_status [ NUM_ELEM ] = {
	PS_SLEEP, 'S', 0,
	PS_RUN,   'R', 0,
	PS_STOP,  'T', 0,
	PS_ZOMBIE,'Z', 0,
	PS_IDLE,  'I', 0,
	PS_OTHER, 'O', 0
};

#else

struct _status {
	char car;
	int num;
};

static struct _status ret_status [ NUM_ELEM ] = {
	'R', 0, /* RUN */
	'S', 0, /* SLEEP */
	'D', 0, /* SWAPPING | UNINTERRUPTIBLE */
	'Z', 0, /* ZOMBIE */
	'T', 0, /* STOP */
	'.', 0  /* OTHER */
};

#endif /* !linux */

char  get_status ( index )
int index;
{
#if !defined(linux)
	long status = pbuf [ index ].pst_stat;
#else
	char status = pbuf [ index ].pst_stat;
#endif /* !linux */
	register int i;

	for ( i = 0 ; i < NUM_ELEM ; ++i )
#if !defined(linux)
		if ( status == ret_status [ i ].def )
#else
		if ( status == ret_status [ i ].car )
#endif /* !linux */
			return ( ret_status [ i ].car );
	
	return ( '?' );
}

void count_status( nproc )
int nproc;
{
	register int i,j;

	for ( j = 0; j < NUM_ELEM; ++j )
		ret_status [ j ].num = 0L;
		
	for ( i = 0; i < nproc; ++i )
		for ( j = 0; j < NUM_ELEM; ++j )
#if !defined(linux)
			if ( pbuf [ i ].pst_stat == ret_status [ j ].def )
#else
			if ( pbuf [ i ].pst_stat == ret_status [ j ].car )
#endif /* !linux */
					ret_status [ j ].num++;
}

int status_sleep()
{
#if !defined(linux)
	return ( ret_status [ 0 ].num );
#else
	return ( ret_status [ 1 ].num );
#endif /* !linux */
}

int status_run()
{
#if !defined(linux)
	return ( ret_status [ 1 ].num );
#else
	return ( ret_status [ 0 ].num );
#endif /* !linux */
}

int status_stop()
{
#if !defined(linux)
	return ( ret_status [ 2 ].num );
#else
	return ( ret_status [ 4 ].num );
#endif /* !linux */
}

int status_zombie()
{
	return ( ret_status [ 3 ].num );
}

int status_other()
{
#if !defined(linux)
	return ( ret_status [ 4 ].num + ret_status [ 5 ].num );
#else
	return ( ret_status [ 2 ].num + ret_status [ 5 ].num );
#endif /* !linux */
}
