/*
    yamm, Yet Another Micro Monitor
    mpreprocess.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#if defined(linux)
#include <sys/resource.h>
#endif /* linux */
#if defined(NCURSES)
#include "ncurses.h"
#else
#include <curses.h>
#endif /* NCURSES */

#include "define.h"
#include "extern.h"

       /* If you want disable "P" and "K" comment out this lines */
#ifndef SU_COMMAND
#define SU_COMMAND "su"
#endif

#ifndef SU_KILLUSER
#define SU_KILLUSER 9
#endif

#ifndef SU_KILLPROCESS
#define SU_KILLPROCESS 9
#endif


void mpreprocess( ac, av, cmd_line )
int ac;
char *av[], *cmd_line;
{
	int car;
	extern char *optarg;
#if !defined (linux)
	extern long atol();
#endif /* !linux */

	if ( !av ) {
		car = ac; 
		goto jump;  /* :-) */
	}

#if !defined(linux)
	while ( ( car = getopt ( ac, av, cmd_line ) ) != EOF )
#else
/*
 * Linux's getopt is a little different form the one of HP-UX, so
 * i need to break the while before call getopt() if the av=NULL
 */
	while ( av != NULL && ( car = getopt ( ac, av, cmd_line ) ) != EOF )
#endif /* !linux */

jump:

	switch ( car ) {
#if defined(NCURSES)
		case '-':
#if defined(KEY_LEFT)
		case KEY_LEFT:
#endif /* KEY_LEFT */
			init_pair( MAIN_PAIR,
				(fgc = fgc == 0 ? COLORS - 1 : fgc - 1), bgc );
#if 0
			curses_error("Foreground color changed");
#endif
			refresh_all();
			break;
		case '=':
#if defined(KEY_RIGHT)
		case KEY_RIGHT:
#endif /* KEY_RIGHT */
			init_pair( MAIN_PAIR,
				fgc = fgc == COLORS - 1 ? 0 : fgc + 1, bgc );
#if 0
			curses_error("Foreground color changed");
#endif
			refresh_all();
			break;
		case '_':
			init_pair( MAIN_PAIR,
				fgc, (bgc = bgc == 0 ? COLORS - 1 : bgc - 1) );
#if 0
			curses_error("Background color changed");
#endif
			refresh_all();
			break;
		case '+':
			init_pair( MAIN_PAIR,
				fgc, (bgc = bgc == COLORS - 1 ? 0 : bgc + 1) );
#if 0
			curses_error("Background color changed");
#endif
			refresh_all();
			break;
#endif /* NCURSES */
		case 'm':
			if ( look_uid == -1L )
				look_uid = getuid();
			else
				look_uid = -1L;
			pages = 0;
			who = 0;
			reverse = 0;
			reverse_index = -1;
			look_utmp = 0;
		break;
		case 'C':
			print_configuration = 1;
			who = 0;
			look_utmp = 0;
			reverse = 0;
			reverse_index = -1;
			look_process = -1;
		break;
		case 'V':
			vm_config = 1;
			who = 0;
			look_utmp = 0;
			reverse = 0;
			reverse_index = -1;
			look_process = -1;
			print_configuration = 0;
		break;
		case '%':
			if ( look_cols() < 90 )
				wcpu = !wcpu;
		break;
		case 'e':
			who = 0;
			look_utmp = !look_utmp;
		break;
#ifdef NO_CURSES
		case 'L':
			long_format = 1;
		break;
#endif
#ifndef NO_CURSES
		case ' ':
		case '\n':
			look_process = -1L;
			pages = print_configuration = vm_config = who = look_utmp =0;
			Num_display_proc = look_lines() - 6;
			reverse = 0;
			reverse_index = -1;

			if ( car == ' ' )  {
				order = NULL;
				look_uid = -1;
				if ( sstring ) {
					reg_set ( NULL );
					sstring = 0;
				}
			}

		break;
		case 'j':
#if defined(KEY_DOWN)
		case KEY_DOWN:
#endif /* KEY_DOWN */
			if ( displayed && reverse <= displayed )
				reverse++;

			if ( displayed && reverse > displayed  ) {
				reverse = 0;
				reverse_index = -1;
			}
		break;
		case 'k':
#if defined(KEY_UP)
		case KEY_UP:
#endif /* KEY_UP */
			if ( displayed && reverse == 0 )
				reverse = displayed + 1;   /* Next instruct decrement reverse */

			if ( displayed && reverse > 0 )
				reverse--;

			if ( displayed && reverse == 0 )
				reverse_index = -1;
		break;
		case 'f':
#if defined(KEY_NPAGE)
		case KEY_NPAGE:
#endif /* KEY_NPAGE */
			if ( displayed )
				pages++;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'b':
#if defined(KEY_PPAGE)
		case KEY_PPAGE:
#endif /* KEY_PPAGE */
			if ( --pages < 0 )
				pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'B':
#if defined(KEY_HOME)
		case KEY_HOME:
#endif /* KEY_HOME */
			pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'I':
			if ( reverse ) 
				look_uid = pbuf [ reverse_index ].pst_uid;

			if ( look_uid != -1L )
				user_info();

			reverse = 0;
			reverse_index = -1;
		break;

#if defined (SU_COMMAND) && (SU_KILLPROCESS)
		case 'P':
#if defined(KEY_DC)
		case KEY_DC:
#endif /* KEY_DC */
		{
			char buf[ 128 ], *user;
			long ret, pid;
			int signo = SU_KILLUSER;

			if ( !reverse )
				break;

			pid = pbuf [ reverse_index ].pst_pid;
			user = get_user ( reverse_index );

			sprintf ( buf, "kill proc %ld (%s) ? ( type 1 to confirm KILL, 9 change signal ): ", pid, user );
			ret = ask_curses ( buf );

			if ( ( ret != 1 ) && ( ret != 9 ) )
				break;

			if ( ret == 9 ) {
				char *sptr;

				sprintf( buf, "which signal ? (type signumber or signame ) : " );

				sptr = curses_get_string ( buf );
				ret = atol ( sptr );

				if ( ret && ret < NSIG )
					signo = ret;
				else {
#if defined(STRFY)
					int size = strlen ( sptr );
					for ( ret = 0; signames [ ret ].signo; ret++ )
						if (( size > 3 && !strncmp(signames [ ret ].name, sptr, size ) ) ||
						    !strncmp(signames [ ret ].name + 3, sptr, size) ) {
							signo = signames [ ret ].signo;
							goto found;
						}
					break;
#else
					curses_error("Signal names not supported");
					break;
#endif /* STRFY */
				}
			}
			found:

			sprintf ( buf, "%s %s -c \"kill -%d %ld\"",
				SU_COMMAND, user, signo , pid );

			if ( kill ( pid, signo ) == -1 )
				system ( buf );

			refresh_all();
			}
		break;
#endif
#if defined (SU_COMMAND) && (SU_KILLUSER)
		case 'K':
			{
			char buf[ 128 ], *user;
			long ret;

			if ( !reverse )
				break;

			user = get_user ( reverse_index );
			sprintf ( buf, "kill user %s ? ( type 1 to confirm ): ", user );
			ret = ask_curses ( buf );
			if ( ret != 1 )
				break;

			sprintf ( buf, "%s %s -c \"kill -%d -1\"",
				SU_COMMAND, user, SU_KILLUSER );

			system ( buf ); 
			refresh_all();
			}
		break;
#endif
		case 'R':
		{
			char buf [ 128 ];
			if ( reverse ) {
				look_process = pbuf [ reverse_index ].pst_pid;
				sprintf ( buf, "User %s (%ld). Type New priority: ",
					get_user ( reverse_index ) ,
					look_process );
			}
			else {
				look_process = ask_curses ( "Type Process number: " );
				sprintf ( buf, "Process %ld. Type New priority: ",
					look_process );
			}


#if !defined(linux)
			renice ( ( int )look_process, ( int )ask_curses ( buf ));
#else
			renice ( PRIO_PROCESS, ( int )look_process, ( int )ask_curses ( buf ));
#endif /* linux */
			
			look_process = -1L;
		}
		break;
#if defined(linux)
		case 'G':
		{
			char buf [ 128 ];
			if ( reverse ) {
				look_process = pbuf [ reverse_index ].pst_pgrp;
				sprintf ( buf, "User %s (%ld). Type New priority: ",
					get_user ( reverse_index ) ,
					look_process );
			}
			else {
				look_process = ask_curses ( "Type Process group: " );
				sprintf ( buf, "Process %ld. Type New priority: ",
					look_process );
			}


			renice ( PRIO_PGRP, ( int )look_process, ( int )ask_curses ( buf ));
			
			look_process = -1L;
		}
		break;
		case 'A':
		{
			char buf [ 128 ];
			if ( reverse ) {
				look_process = pbuf [ reverse_index ].pst_uid;
				sprintf ( buf, "User %s (%ld). Type New priority: ",
					get_user ( reverse_index ) ,
					look_process );
			}
			else {
				look_process = ask_curses ( "Type User ID: " );
				sprintf ( buf, "Process %ld. Type New priority: ",
					look_process );
			}


			renice ( PRIO_USER, ( int )look_process, ( int )ask_curses ( buf ));
			
			look_process = -1L;
		}
		break;
#endif /* linux */
#endif
		case 'p':

			if ( reverse ) 
				look_process = pbuf [ reverse_index ].pst_pid;

			else

				if ( av )
					look_process = atol ( optarg );
				else
					look_process = ask_curses ( "Type Process number: " );
			who = 0;
			look_utmp = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'E':
			set_euid = !set_euid;
			pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'w':
			who = !who;
			pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'W':
			if ( av )
				wait_second = atoi ( optarg );
			else
				wait_second = ( int )ask_curses ( "Type seconds: " );

			if ( wait_second < 0 )
				wait_second *= -1;
		break;
		case '/':
			if ( av ) {
				reg_set ( optarg );
				sstring = 1;
			}
			else {
				char *search = curses_get_string ( "Type string to search: " );
				if ( search ) {
					reg_set ( search );
					sstring = 1;
				}
				else {
					sstring = 0;
					reg_set ( NULL );
				}
			}
		break;
		case 'N':
			if ( av )
				Num_display_proc = atoi ( optarg ); 
			else {
				int lines = look_lines ();
				Num_display_proc =
					( int )ask_curses ( "Type number of processes: " );
				if ( Num_display_proc > lines - 6 || Num_display_proc < 0 )
					Num_display_proc = lines - 6;
			}
			pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'i':
			invert = !invert;
		break;
		case 's':
			order = compare_start_time;
		break;
		case 'd':
			order = compare_size;
		break;
		case 'D':
			order = compare_ressize;
		break;
		case 't':
			order = compare_user_time;
		break;
		case 'c':
			order = compare_sched_time; /* added by HV */
		break;
		case 'S':
			system_time_include = 1;
			user_time_include = !user_time_include;
		break;
		case 'U':
			user_time_include = 1;
			system_time_include = !system_time_include;
		break;
		case 'u':

			if ( reverse ) 
				look_uid = pbuf [ reverse_index ].pst_uid;

			else

				if ( av )
					if ( *optarg < '0' || *optarg > '9' )
						look_uid = get_user_id ( optarg );
					else
						look_uid = atol ( optarg );
				else {
					char *u_name = curses_get_string ( "Type uid or name ( <RET> for previous state ): " );

					if ( !u_name )
						look_uid = -1L;
					else
						if ( *u_name < '0' || *u_name > '9' ) 
							look_uid = get_user_id ( u_name );
						else
							look_uid = atol ( u_name );
				}

			if ( look_uid == 0L )   /* look for root */
				allow_root =1;

			pages = 0;
			who = 0;
			look_utmp = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		case 'r':
			allow_root = !allow_root;
			pages = 0;
			reverse = 0;
			reverse_index = -1;
		break;
		default:
			if ( !av )
				return;

			puts ( "-m          -  Display only 'm'y processes.");
			puts ( "-s          -  Sort by 's'tart time." );
			puts ( "-t          -  Sort by process 't'ime."  );
			puts ( "-c          -  Sort by process %cpu time, default." ); /* HV */
			puts ( "-d          -  Sort by process size ( data + text + stack ).");
			puts ( "-D          -  Sort by process resident set size.");
			puts ( "-E          -  Show processes with uid != euid.");
			puts ( "-r          -  Allow display of 'r'oot process." );
			puts ( "-%          -  Switch between  STIME and WCPU fields." );
			puts ( "-u uid|name -  Restrict to a specific 'U'ser." );
#ifdef NO_CURSES
			puts ( "-L          -  Display long format of command name." );
#endif
			puts ( "-i          -  Invert sorting order." );
			puts ( "-e          -  Display the entries in utmp." );
			puts ( "-S          -  Display only System time to field \"TIME\" that normally is system_time + user_time.");
			puts ( "-U          -  Display only User time to field \"TIME\".");
			puts ( "-p process  -  Analyze a single process" );
			puts ( "-C          -  Display configuration of machine." );
			puts ( "-V          -  Virtual memory info." );
			puts ( "-w          -  Like who." );
			puts ( "-N number   -  Display only \"number\" process." );
			puts ( "-/ string   -  Search string in command line.");
			puts ( "-W second   -  Loop forever waiting \"second\" for each loop ( type DELETE or QUIT to exit." );
			exit ( 1 );
		break;
	}
#if defined(linux)
/*
 * Read all the waiting characters to disable typematic behaviour
 */
#define __KBHIT stdin->_IO_read_ptr < stdin->_IO_read_end
	while ( __KBHIT )
		car = getchar();
#endif /* linux */
}
