/*
    yamm, Yet Another Micro Monitor
    user_time.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/time.h>
#include "define.h"
#include "extern.h"

#define MAX_BUF 10

int compare_user_time( a, b )
struct pst_status *a,*b;
{
	long second_a = 0L +
		( user_time_include ? a->pst_utime : 0L ) + 
		( system_time_include ? a->pst_stime : 0L );

	long second_b = 0L +
		( user_time_include ? b->pst_utime : 0L ) +
		( system_time_include ? b->pst_stime : 0L );

	if ( invert )
		return ( second_a < second_b ? -1 : second_a == second_b ? 0 : 1 );
	else
		return ( second_a < second_b ? 1 : second_a == second_b ? 0 : -1 );
		
}

char  *visual_user_time ( index )
int index;
{
	static char buf[ MAX_BUF ];
	long second = 0L +
		( user_time_include ?   pbuf [ index ].pst_utime : 0L ) +
		( system_time_include ? pbuf [ index ].pst_stime : 0L );

	long minute = second / 60;

	second = second - ( minute * 60 );
	
	if ( minute > 9999L )
		sprintf ( buf ,"%5ld:%1ld",
			minute, second );
	else
		sprintf ( buf ,"%4ld:%2ld",
			minute, second );
		

	buf [ MAX_BUF - 1 ] = '\0';
	return ( buf );
}
