/*
    yamm, Yet Another Micro Monitor
    wchan.c
    Copyright (C) 1994  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if defined(linux)

#include <string.h>
#include "define.h"
#include "extern.h"

struct func_tab *ftab;
int ftab_size;
static int success = 0;

int read_ftab(void)
{
	FILE *fp;
	char buffer[128];
	int i = 0;

	fp = fopen ("/etc/zSystem.map", "r");
	if (!fp)
		return -1;

	while(fgets(buffer, 128, fp)) {
		i++;
		ftab = (struct func_tab *)realloc ( ftab, i * sizeof(struct func_tab) );
		if (ftab == NULL)
			return -1;
		if (sscanf(buffer, "%lx %c %s",
					&ftab [ i-1 ].start,
					&ftab [ i-1 ].type,
					 ftab [ i-1 ].name ) != 3) {
			free (ftab);
			return -1;
		}
/*
 * Strip first char if is equal to '_'
 */
		if (ftab[ i-1 ].name[0] == '_')
			strcpy(ftab[ i-1 ].name, &ftab[ i-1 ].name[1]);

/*
 * Strip sys_ head if exist
 */
		if (!strncmp(ftab[ i-1 ].name, "sys_", 4))
			strcpy(ftab[ i-1 ].name, &ftab[ i-1 ].name[4]);
	}
	i++;
	ftab = (struct func_tab *)realloc ( ftab, i * sizeof(struct func_tab) );
	memset(&ftab [ i-1 ], 0, sizeof(struct func_tab) );
	ftab_size = i;
	success = 1;
	return 0;
}

int search_func( unsigned long wchan )
{
	int i;

	if (!success)
		return -1;

	for (i=0; ftab [ i ].type; i++) {
		if (ftab [ i ].start <= wchan) {
			if (i+1 >= ftab_size)
				return i;
			if (ftab [ i+1 ].start > wchan)
				return i;
			continue;
		}
		return -1;
	}
	return -1;
}

#endif /* linux */
