#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <sys/param.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>

#include "filemgr.h"
#include "debug.h"

#include "garbage.xpm"
#include "full_garbage.xpm"

XpmIcon garbage;
XpmIcon full_garbage;
Window garbage_win;

GC  NormalGC,ShadowGC,ReliefGC, rvGC;
Pixel hilite_pix, back_pix, shadow_pix, fore_pix;
Atom wm_del_win;
Atom _XA_WM_PROTOCOLS;
extern XFontStruct *font;
int font_height;
extern int max_w,max_h;

Display *dpy;
int x_fd,screen, ScreenWidth,ScreenHeight;
int d_depth;
Window Root;

extern char *MyName,*ForeColor, *BackColor,*font_string;
extern struct mapping *mapping_root;

void initialize_X(void)
{
  char *display_name = NULL;

  /* Open the Display */
  if (!(dpy = XOpenDisplay(display_name))) 
    {
      fprintf(stderr,"%s: can't open display %s\n", MyName,
	      XDisplayName(display_name));
      free_mapping(mapping_root);
      exit (1);
    }
  x_fd = XConnectionNumber(dpy);
  screen= DefaultScreen(dpy);
  Root = RootWindow(dpy, screen);
  d_depth = DefaultDepth(dpy, screen);

  ScreenHeight = DisplayHeight(dpy,screen);
  ScreenWidth = DisplayWidth(dpy,screen);
  if(max_w == 0)
    max_w = ScreenHeight;
  if(max_h == 0)
    max_h= ScreenHeight;
  
  wm_del_win = XInternAtom(dpy,"WM_DELETE_WINDOW",False);
  _XA_WM_PROTOCOLS = XInternAtom (dpy, "WM_PROTOCOLS", False);
}

void LoadXThings(void)
{
  XGCValues gcv;
  unsigned long gcm;

  /* load the font */
  if ((font = XLoadQueryFont(dpy, font_string)) == NULL)
    {
      if ((font = XLoadQueryFont(dpy, "fixed")) == NULL)
	{
	  fprintf(stderr,"%s: No fonts available\n",MyName);
	  free_mapping(mapping_root);
	  exit(1);
	}
    };

  font_height = font->ascent+font->descent+4;

  if(d_depth < 2)
    {
      back_pix = GetColor("white");
      fore_pix = GetColor("black");
      hilite_pix = back_pix;
      shadow_pix = fore_pix;
    }
  else
    {
      back_pix = GetColor(BackColor);
      fore_pix = GetColor(ForeColor);
      hilite_pix = GetHilite(back_pix);
      shadow_pix = GetShadow(back_pix);
    }


  gcm = GCForeground|GCBackground;
  gcv.foreground = hilite_pix;
  gcv.background = back_pix;
  ReliefGC = XCreateGC(dpy, Root, gcm, &gcv);  

  gcm = GCForeground|GCBackground;
  gcv.foreground = shadow_pix;
  gcv.background = back_pix;
  ShadowGC = XCreateGC(dpy, Root, gcm, &gcv);  

  gcm = GCForeground|GCBackground|GCFont;
  gcv.foreground = fore_pix;
  gcv.background = back_pix;
  gcv.font =  font->fid;
  NormalGC = XCreateGC(dpy, Root, gcm, &gcv);  

  gcm = GCForeground|GCBackground|GCFont;
  gcv.foreground = back_pix;
  gcv.background = fore_pix;
  gcv.font =  font->fid;
  rvGC = XCreateGC(dpy, Root, gcm, &gcv);  

  garbage.attributes.valuemask |= XpmReturnPixels;
  garbage.attributes.valuemask |= XpmReturnExtensions;

  if(XpmCreatePixmapFromData(dpy, Root, garbage_xpm,
			     &garbage.pixmap, &garbage.mask,
			     &garbage.attributes)!= XpmSuccess)
    exit(1);

  full_garbage.attributes.valuemask |= XpmReturnPixels;
  full_garbage.attributes.valuemask |= XpmReturnExtensions;
  if(XpmCreatePixmapFromData(dpy, Root, full_garbage_xpm,
			     &full_garbage.pixmap, &full_garbage.mask,
			     &full_garbage.attributes)!= XpmSuccess)
    exit(1);

  garbage_win  = XCreateSimpleWindow(dpy,Root,0,0,
				     garbage.attributes.width,
				     garbage.attributes.height,
				     0,fore_pix,back_pix);  
  

}

/****************************************************************************
 *
 * This routine computes the hilight color from the background color
 *
 ****************************************************************************/
Pixel GetHilite(Pixel background) 
{
  XColor bg_color, white_p;
  XWindowAttributes attributes;
  
  XGetWindowAttributes(dpy,Root,&attributes);
  
  bg_color.pixel = background;
  XQueryColor(dpy,attributes.colormap,&bg_color);

  white_p.pixel = GetColor("white");
  XQueryColor(dpy,attributes.colormap,&white_p);
  
#ifndef min
#define min(a,b) (((a)<(b)) ? (a) : (b))
#define max(a,b) (((a)>(b)) ? (a) : (b))
#endif

  bg_color.red = max((white_p.red/5), bg_color.red);
  bg_color.green = max((white_p.green/5), bg_color.green);
  bg_color.blue = max((white_p.blue/5), bg_color.blue);
  
  bg_color.red = min(white_p.red, (bg_color.red*140)/100);
  bg_color.green = min(white_p.green, (bg_color.green*140)/100);
  bg_color.blue = min(white_p.blue, (bg_color.blue*140)/100);
  
  if(!XAllocColor(dpy,attributes.colormap,&bg_color))
    nocolor("alloc hilight","");
  
  return bg_color.pixel;
}


void nocolor(char *a, char *b)
{
 fprintf(stderr,"%s: can't %s %s\n", MyName, a,b);
}


/****************************************************************************
 * 
 * Loads a single color
 *
 ****************************************************************************/ 
Pixel GetColor(char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes(dpy,Root,&attributes);
  color.pixel = 0;
   if (!XParseColor (dpy, attributes.colormap, name, &color)) 
     {
       nocolor("parse",name);
     }
   else if(!XAllocColor (dpy, attributes.colormap, &color)) 
     {
       nocolor("alloc",name);
     }
  return color.pixel;
}

/****************************************************************************
 *
 * This routine computes the shadow color from the background color
 *
 ****************************************************************************/
Pixel GetShadow(Pixel background) 
{
  XColor bg_color;
  XWindowAttributes attributes;
  
  XGetWindowAttributes(dpy,Root,&attributes);
  
  bg_color.pixel = background;
  XQueryColor(dpy,attributes.colormap,&bg_color);
  
  bg_color.red = (unsigned short)((bg_color.red*50)/100);
  bg_color.green = (unsigned short)((bg_color.green*50)/100);
  bg_color.blue = (unsigned short)((bg_color.blue*50)/100);
  
  if(!XAllocColor(dpy,attributes.colormap,&bg_color))
    nocolor("alloc shadow","");
  
  return bg_color.pixel;
}

