/* $Header: deliver.h,v 2.9 90/05/15 11:21:55 chip Exp $
 *
 * General pull-it-together include file.
 *
 * $Log:	deliver.h,v $
 * Revision 2.9  90/05/15  11:21:55  chip
 * Add skipfrom().
 * 
 * Revision 2.8  90/03/06  12:17:42  chip
 * Move logging into log.c and address parsing into addr.c.
 * New: error delivery file for messages that fail.
 * Major rearrangement of delivery file code.
 * 
 * Revision 2.7  90/02/23  14:15:58  chip
 * Support "#!" in delivery files.
 * Support "user|program" and "user?error" from delivery files.
 * Improve debugging and error message formatting.
 * Rearrange code for clarity.
 * 
 * Revision 2.6  90/02/06  11:54:45  chip
 * Enforce MBX_MODE regardless of UMASK.
 * Enforce ordered logging with a log lockfile.
 * Revise log format.
 * 
 * Revision 2.5  89/11/10  12:23:51  network
 * Handle recursion.
 * 
 * Revision 2.4  89/11/01  12:18:59  network
 * Delintify.
 * 
 * Revision 2.3  89/11/01  11:51:40  network
 * Add logging.
 * 
 * Revision 2.2  89/09/29  18:17:56  network
 * Save message when delivery file produces no output,
 * unless delivery file output the "DROP" string.
 * Don't recopy temp files for sys and post-user delfiles.
 * 
 * Revision 2.1  89/06/09  12:25:21  network
 * Update RCS revisions.
 * 
 * Revision 1.10  89/06/09  12:23:44  network
 * Baseline for 2.0 release.
 * 
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#include "config.h"
#include "misc.h"
#include "context.h"
#include "dest.h"

/*----------------------------------------------------------------------
 * Global data
 */

extern  int     verbose;        /* Print debugging messages?            */
extern  int     dryrun;         /* Are we making a dry run?             */
extern  int     rundfiles;      /* Run delivery files at all?           */
extern  int     printaddrs;     /* Address resolution only?             */
extern  int     leavetemps;     /* Leave temp files for later perusal   */
extern  int     boxdelivery;    /* Args are mailboxes, not addresses    */

extern  char    *progname;      /* Name this program was invoked under  */
extern  char    version[];      /* Version and patchlevel               */
extern  char    *shell;         /* Shell used to run delivery files     */

extern  int     rec_parent;     /* If recursing, parent deliver's pid   */
extern  int     rec_level;      /* If recursing, recursion level        */
extern  char    *sys_deliver;   /* Systemwide delivery file             */
extern  char    *post_deliver;  /* Post-user delivery file              */
extern  char    *err_deliver;   /* Error delivery file                  */
extern  char    *user_deliver;  /* User delivery file                   */
extern  char    *sender;        /* Who is sending this message?         */
extern  char    *hostname;      /* Name of this host                    */

extern  int     eff_uid;        /* Returned by geteuid()                */
extern  int     eff_gid;        /* Returned by getegid()                */
extern  int     real_uid;       /* Returned by getuid()                 */
extern  int     real_gid;       /* Returned by getgid()                 */

extern  CONTEXT *eff_ct;        /* Context of effective uid             */
extern  CONTEXT *real_ct;       /* Context of real uid                  */

extern  int     trust_user;     /* Do we trust the user that called us? */
extern  int     trust_delfiles; /* Do we trust the delivery files?      */

extern  FILE    *log;           /* File to log deliveries               */
extern  char    *logfile;       /* Temporary file for log               */
extern  FILE    *errlog;        /* File to log messages and errors      */
extern  char    *errlogfile;    /* Temporary file for error log         */

extern  int     tty_input;      /* Is our input coming from a tty?      */
extern  SIGFLAG got_sig;        /* Did we catch a deadly signal?        */

/* Temp file indices: */
#define T_HDR      0    /* Message header                       */
#define T_BODY     1    /* Message body                         */
#define T_HDRCOPY  2    /* Copy of message header               */
#define T_BODYCOPY 3    /* Copy of message body                 */
#define T_MAX      4    /* Number of temp files                 */

extern  char    *ttype[T_MAX];  /* Temp file types (for messages)       */
extern  char    *tfile[T_MAX];  /* Temp file names                      */
extern  char    *tenv[T_MAX];   /* Temp file environment names          */
extern  int     tfd[T_MAX];     /* Temp file fd's                       */

extern  SIGFLAG got_sig;        /* We caught a signal and should exit   */

/*----------------------------------------------------------------------
 * Global functions
 */

char    *tempfile();
char    *basename();
char    *relpath();
char    *gethost();
char    *skipfrom();
char    *copystr();
char    *derrmsg();
char    *zalloc();
char    *srealloc();

char	**choose_args();

CONTEXT *name_context();
CONTEXT *uid_context();

FILE    *ftcreate();
FILE    *ct_fopenv();

DEST    *addr_dest();
DEST    *dest();
DEST    *first_dest();
DEST    *next_dest();
DEST	**dest_array();

DCLASS	addr_class();

time_t  unctime();
