/*
 * db_management.c: some maintenance routines to deal with database access.
 * 
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Thu Apr 28 21:31:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MANPATH_MAIN	/* to not define *std_sections[] */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "config.h"
#include "mydbm.h"
#include "dbver.h"

extern int debug; 
extern char *database;
extern struct compress_ext decompress[];

int try_section (char *path, char *section, char *name, int glob);

void remove_db_entry(char *fullpath, datum key)
{
	datum content;
	MYDBM_FILE dbf;

	if( (dbf = MYDBM_RWOPEN(database)) != NULL){

		/* re-get the manpage list from the db */
				
		dbver_rd(dbf);

		content = MYDBM_FETCH(dbf, key);
	
		if (debug)
			fprintf(stderr, "remove_db_entry: %s from %s\n", fullpath, content.dptr);
	
		if (strchr(content.dptr, ':') == NULL)
					
			/* manpage is lonely, just bin it. */
						
			MYDBM_DEL(dbf, key);
		else {
			/* manpage has friends, find it and bin it. */
			
			char *start, *end;
			
			start = strstr(content.dptr, fullpath);
			end = strchr(start, ':');
	
			if (end == NULL)
				*(--start) = '\0';
			else 
				strcpy(start, ++end);
	
			content.dsize = strlen(content.dptr) + 1;
			MYDBM_REPLACE(dbf, key, content);
		}
		MYDBM_FREE(content.dptr);
		MYDBM_CLOSE(dbf);
	}
	else {
		if (debug)
			fprintf(stderr,
			  "remove_db_entry: couldn't open db: %s in RW mode\n", database);
	}
}

/*
 * Here we see if the db found page (a) has the correct section 
 * (if any specified), (b) has a path that matches the user's MANPATH and
 * (c) exists in reality.
 */
int try_db_manpage(char *fullpath, datum key, char *section)
{
	/* 
	 * we can happily trash contents of fullpath.
	 * except we can't due to remove_db_entry, which needs the 
	 * fullpath
	 */
	
	char *sec;
	char *bigpath;
	int exists = 0;
	extern char *manpathlist[];
	extern char *alt_system_name;
	char **mp;
#ifdef COMP_SRC
	struct compress_ext *comp;
#endif

	bigpath = strdup(fullpath);

	/*
	 * isolate the section number
	 *
	 * MUST use strrchr due to man pages like ld.so.8
	 */
	
	sec = strrchr (bigpath, '.');

#ifdef COMP_SRC
	/* deal with compression ext */
	
	for (comp = decompress; comp->ext; comp++)
		if (strcmp(sec, comp->ext) == 0) {
			*sec = '\0';
			sec = strrchr (bigpath, '.');
			break;
		}
#endif
	sec++;

	/*
	 * see if the found man page has the correct section number
	 * (if section has been set)
	 */
	 
	if (section == NULL || strncmp (sec, section, strlen(section)) == 0){

		*strrchr (bigpath, '/') = '\0';
		*strrchr (bigpath, '/') = '\0';

		/* 
		 * now check to see if the path found in the db is also
		 * in the manpath, (filters out -M . etc).
		 */

		for (mp = manpathlist; *mp && strcmp(*mp, bigpath); mp++)
				continue;
		/*				
		 * For alt_system support, we should check that the file
		 * resides in the alt_system path. 
		 */
	
		if (alt_system_name &&
		    !strstr( alt_system_name, strrchr(bigpath, '/') + 1) )
				*mp = NULL;

		if (*mp) {

			/* 
			 * see if the db manpage actually exists in reality.
			 * if so, show it.
			 */

			exists = try_section (bigpath, sec, key.dptr, 0);

			if (!exists)
			
				/*
				 * We should remove the page from the db
				 */

				remove_db_entry(fullpath, key);
		}	
		else 
			if (debug)
				fprintf(stderr, "but... db path: %s is not in man_searchpath\n", bigpath);
	}
	free(bigpath);
	return exists;
}
