#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <stdio.h>

#include "config.h"
#include "mydbm.h"

extern char *prognam;

int dbver(MYDBM_FILE dbf)
{
	datum key, content;

	key.dptr = VER_KEY;
	key.dsize = sizeof VER_KEY;

	content = MYDBM_FETCH(dbf, key);

	if (content.dptr == NULL)
		return -1;
	else if (strcmp(content.dptr, VER_ID) != 0)
		return 1;
	else
		return 0;

}

void dbver_wr(MYDBM_FILE dbf)
{
	datum key, content;

	key.dptr = VER_KEY;
	key.dsize = sizeof VER_KEY;
	content.dptr = VER_ID;
	content.dsize = sizeof VER_ID;
	
	if (MYDBM_INSERT(dbf, key, content) != 0) {
		fprintf(stderr, 
		  "%s: dbver_wr: Could not insert version identifier into db !?\n",
		  prognam);
		exit(1);
	}
}

void dbver_rd(MYDBM_FILE dbf)
{
	int status;

	status = dbver(dbf);
	
	if (status == -1)
		fprintf(stderr,
		  "%s: dbver_rd: db does not have a man version ID, cannot continue\n",
		  prognam);
	else if (status == 1)
		fprintf(stderr,
		  "%s: dbver_rd: incompatible man db version, expecting: "
		  VER_ID "\n",
		  prognam);
	else
		return;

	exit(1);
}
	
