/*
 * getwhatis.c
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * get as much info as possible from the man/cat files. 
 *
 * Tue May  3 21:24:51 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "util.h"
#include "manp.h"
#include "convert_name.h"
#include "gripes.h"

extern char *optarg;
#ifndef S_ISLNK
#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#endif

char *prognam;
char *ext;
int debug = 0;
int cat = 0;
static char *temp_name;
static int refs, straycats, manfiles;
char mandir[BUFSIZ];

int find_name(FILE *fd, short cat);
int compile_regs(void);

void catman(char *basename)
{
	char command[BUFSIZ] = "/usr/bin/man -c ";
	char *name, *sec;

	name = strdup(basename);
	if ( (sec = strrchr(name, '.')) == NULL)
		return;
	else
		*sec = '\0';
	strcat(command, ext);
	strcat(command, " ");
	strcat(command, name);

	if (!do_system_command(command))
		exit(1);

	free (name);
}
	
int do_zcat(char *zcatfile)
{
	FILE *temp_file;
	struct stat buf;
	char zcat[BUFSIZ] = DECOMPRESSOR " ";
	int refs;

	if (lstat(zcatfile, &buf) || S_ISLNK(buf.st_mode))
		return 0;
	
	/* it's a real file. Lets zcat it and have a looksie */

	strcat(zcat, zcatfile);
	strcat(zcat, " | " COL " -bx > ");
	strcat(zcat, temp_name);

	if (system(zcat) != 0) {
		perror(zcat); /* should pick up bogus files */
	}

	temp_file = fopen(temp_name, "r");
	refs = find_name(temp_file, 1);
	fclose(temp_file);
	remove(temp_name);

	return refs;
}

void get_files(char *mandir)
{
	DIR *mdir;
	struct dirent *manlist;
	struct stat buf;
	size_t len;
	FILE *file;
	int fd;
	char *catfile;
	
	if ( (mdir = opendir(mandir)) == NULL){
		fprintf(stderr,
		  "%s: get_files: could not open dir for reading: ",
		  prognam);
		perror(mandir);
		return;
	}

	strcat(mandir, "/");
	len = strlen(mandir);
		
	while ((manlist = readdir(mdir)) != NULL) {
		if (*manlist->d_name == '.' && strlen(manlist->d_name) < 3)
		/* catch this dir and parent but allow ..1 or .xinitrc.1x */
			continue;

		strcpy(mandir + len, manlist->d_name);

		if ( (ext = strrchr(mandir, '.')) == NULL) {
			fprintf(stderr, 
			  "%s has no extension, ignoring it.\n",
			  mandir);
			  continue;
		}
		ext++;

		fd = open(mandir, O_RDONLY);
		file = fdopen(fd, "r");
		fstat(fd, &buf);
		
		if (S_ISLNK(buf.st_mode)) {
			/* ignore symlinks, we'll pick em up elsewhere */
			fclose(file);
			close(fd);
			continue;
		} else if (!buf.st_size) { /* place-holder */

			catfile = convert_name(mandir, 0);
			if (is_newer(mandir, catfile) == -2) {
				free(catfile);
				catfile = convert_name(mandir, 1);
				if (is_newer(mandir, catfile) == -2) {
					free(catfile);
					fprintf(stderr,
					  "Warning: Bogus place-holder: %s\n",
					  mandir);
					fclose(file);
					close(fd);
					continue;
				}
			}
			refs += do_zcat(catfile);
			free(catfile); 
			straycats++;
		} else { /* normal */
			refs += find_name(file, 0);
			if (cat)
				catman(manlist->d_name);
			manfiles++;
		}
		fclose(file);
		close(fd);
	}
	closedir(mdir);
}

void compare_dirs(char *path)
{
	DIR *mdir;
	struct dirent *manlist;
	size_t manlen;

	strcpy(mandir, path);

	if ( (mdir = opendir(path)) == NULL){
		fprintf(stderr,
		  "%s: compare_dirs: could not open dir for reading: ",
		  prognam);
		perror(mandir);
		return;
	}
	strcat(mandir, "/");
	manlen = strlen(mandir);
		
	while ((manlist = readdir(mdir)) != NULL){
		if (*manlist->d_name != 'm' && *manlist->d_name != 'M')
			continue;
		strcpy(mandir + manlen, manlist->d_name);
		if (!is_directory(mandir))
			continue;
		get_files(mandir);
	}
	closedir(mdir);
}

int main(int argc, char *argv[])
{
	char *c1, *path = NULL, *alt_system = NULL;
	char *manpathlist[MAXDIRS];
	char **mp;
	int i = 0;
	int c;

	prognam = *argv;

	while ((c = getopt(argc, argv, "dcm:M:")) != -1){

		switch(c) {
			case 'd':
				debug++;
				break;
			case 'c':
				cat++;
				break;
			case 'M':
				path = strdup(optarg);
				break;
			case 'm':
				alt_system = optarg;
				break;
		}
	}				
				
	/* set up the temporary filename for expanded catfiles */
	temp_name = tmpnam(NULL);

	/* compile the regex expressions for later */
	compile_regs();

	if (path != NULL) {
		if (alt_system)
			path = add_system_manpath (alt_system, path);

		/* This is really bogus. Need to call get_dirlist()
		   to set up extern DIRLIST list[]
		   so that later, convert_name() has a chance.
		   This really has to be done somewhere else */
		   
		if (get_dirlist ()) {
			gripe_reading_mp_config (CONFIG_FILE);
		}

		while ( (c1 = strrchr(path, ':')) != NULL){
			*c1 = '\0';
			compare_dirs(++c1);
		}
		compare_dirs(path);
	} else {
		
		/* get the manpath */
		path = manpath(0, alt_system);
	
		while( (c1 = strrchr(path, ':')) != NULL){
			*c1 = '\0';
			manpathlist[i++] = ++c1;
		}
		manpathlist[i++] = path;
		manpathlist[i] = NULL;
	
		/* weed out only the global man dirs */
	
		for (mp = manpathlist; *mp != NULL; mp++) {
			if (global_catpath(*mp) != NULL) {
				fprintf(stderr, "Searching in %s\n", *mp);
				compare_dirs(*mp); 
			}
		}
		
		free(path);
	}

	fprintf(stderr, 
	  "%d manfiles + %d straycats = %d files with %d references\n",
	  manfiles, straycats, manfiles + straycats, refs);
	
	return 0;
}

