/*
 * grog.c: extract as much reference info from the man files as possible
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include "config.h"
#include "regex_replace.h"
	
#include "regex_buffer.h" /* contains big_regex_buffer[] */

#ifndef POSIX
#define POSIX	/* doesn't work otherwise */
#endif

#ifndef POSIX
#define regcomp(preg, regex, flags)	(int)re_compile_pattern(regex, strlen(regex), preg)
#define regexec(preg, string, nmatch, pmatch, eflags)	re_search(preg, string, strlen(string), 0, strlen(string), &pmatch)
#endif

void display_it(char *name, char *desc)
{
	extern char *ext;
	int chars;
	static char string[512];

#ifdef BSD_SPRINTF
	sprintf(string, "%s (%s)", name, ext);
	chars = strlen (string);
#else
	chars = sprintf(string, "%s (%s)", name, ext);
#endif

	if (chars < 20)
		printf("%-20s - %s\n", string, desc);
	else
		printf("%s - %s\n", string, desc);
}

int splitline(char *newname)
{
	char *comma;
	char *description;
	int i = 0;
	
	if ( (description = strstr(newname, " - ")) != NULL) {
		*description = '\0';
		description += 3;
	} else if ( (description = strchr(newname, '-')) != NULL) {
		*description = '\0';
		description++;
	} else {
/*		printf("-- Has name but no description %s\n", newname); */
		return 0;
	}

	while( (comma = strrchr(newname, ',')) != NULL) {
		*comma = '\0';
	/*	entry[i++] = comma + 2; */
		i++;
		display_it(comma + 2, description);
	}
/*	entry[i++] = newname; */
	display_it(newname, description);
	return ++i;
}

int find_name(FILE *fs, short cat)
{
	short has_name = 0;
	char name[1024];
	char *newname = NULL;
	char *sep;
#ifdef POSIX
	regmatch_t dummy[1];
#else
	struct re_registers dummy;
#endif
	struct big_regex_buffer *local;
	struct small_regex_buffer *find;
	int refs = 0;

	find = regex_find;
	local = regex_buf;
	
	while (!has_name && fgets(name, 512, fs) != NULL) {
		if ( (!cat && regexec(find->preg, name, 0, dummy, 0) == 0)
		  || regexec((find + 2)->preg, name, 0, dummy, 0) == 0) { 
			*(name + fread(name, sizeof (char), 512, fs)) = '\0';
			if ( (!cat && regexec((find + 1)->preg, name, 1, dummy, 0) == 0)
			  || regexec((find + 3)->preg, name, 1, dummy, 0) == 0) {
#ifdef POSIX
				*(name + dummy[0].rm_so) = '\0';
#else
				printf("start: %d, end %d\n", dummy.start[0], dummy.end[0]);
				*(name + dummy.start[0]) = '\0';
#endif
				has_name++;
			} else {
				/* 
				 * something a bit odd about this file.
				 */
				return 0;
			}
		}
	}

	if (has_name) {
		newname = name;

		if (cat) {
			newname = regex_replace((local + 5)->preg, newname,
				(local + 5)->replace);
			newname = regex_replace((local + 6)->preg, newname,
				(local + 6)->replace);
		} else
	 		while(local->regex != NULL) {
	 			newname = regex_replace(local->preg, newname, 
	 			  local->replace);
	 			local++;
	 		}

		while ( (sep = strrchr(newname, 0x11)) != NULL) {
			*sep = '\0';
			refs += splitline(++sep);
		}
		refs += splitline(newname);
	}
	return refs;
}

void compile_regs(void)
{
	struct big_regex_buffer *local;
	struct small_regex_buffer *find;
	int ret = 0;

#ifndef POSIX
	re_syntax_options = RE_SYNTAX_POSIX_EXTENDED;
#endif
	local = regex_buf;
	find = regex_find;

	/* regex exp's for finding the actual 'NAME' section */

	while(find->regex != NULL) {
		find->preg = (regex_t *) malloc (sizeof (regex_t));
		ret += regcomp(find->preg, find->regex,
		  REG_EXTENDED|REG_NEWLINE);
		find++;
	}
	
	/* regex exp's for sifting through the description */

	while(local->regex != NULL) {
		local->preg = (regex_t *) malloc (sizeof (regex_t));
		ret += regcomp(local->preg, local->regex,
		  REG_EXTENDED|REG_NEWLINE);
		local++;
	}

	if (ret) {
		fputs("At least one of the REGEX compilations failed\n", 
		  stderr);
		exit(1);
	}
}
