#!/bin/sh
# makewhatis: create the whatis database
# Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
#
# You may distribute under the terms of the GNU General Public
# License as specified in the file COPYING that comes with the man
# distribution.
#
# Sun May 22 18:09:18 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
# Sun Jun 19 12:14:06 BST 1994  Wilf. 

PATH=/usr/local/bin:/usr/bin:/bin:$PATH

if test "$2" !=  ""
then
        echo "Usage: makewhatis [colon_delimited_manpath]";
        exit

elif test "$1" != ""
then
	manpath=`echo $1 | tr : '\040'`
else
	manpath=`%bindir%/manpath -q | tr : '\040'`
fi

if [ "$manpath" = "" ]
then
    echo "makewhatis: manpath is null"
    exit 1
fi

SYSTEM=

for i in $manpath
do
	catpath=`MANPATH="$i" %bindir%/manpath -cq`

	touch $catpath/whatis && echo "Scanning files under $i to create $catpath/whatis" && getwhatis -M $i | sort | uniq > $catpath/whatis
done
exit	
