/*
 * newman.c
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * These are either newly added routines or completely re-written pieces of
 * code inspired by routines in man.c
 *
 * Mon May  2 11:14:28 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <dirent.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "mydbm.h"
#include "newman.h"
#include "gripes.h"
#include "util.h"
#include "statdir.h"
#include "convert_name.h"
#include "dbver.h"

int man (char *name);

extern int debug;
extern char *prognam;
extern short db;
extern MYDBM_FILE dbf;
extern char *database;
extern char *manpathlist[];
extern short findall;

#ifdef FSSTND

char *catpath (char *path)
{
	char *newpath;

	if ( (newpath = global_catpath(path)) == NULL)
		return path;
	else
		return newpath;
}
#endif

#ifdef TRACE_SYMLINK
/* convert absolute path into relative path */
void relative(char *abspath, char *subdir)
{
	char *s, *temp;
	int i = 0;

	/* count the dirs */
	temp = strdup(abspath);
	while ( (s = strrchr(temp, '/')) != NULL) {
		i++;
		*s = '\0';
	}
	free(temp);
	
	/* put in the "../" s */
	temp = strdup(subdir);
	*subdir = '\0';
	while (i--)
		strcat(subdir, "../");

	/* put it back together again */
	strcat(subdir, "..");
	strcat(subdir, temp);
	free(temp);
}
#endif

/*
 * recursive function which finds the ultimate source file by following
 * any ".so filename" directives in the first line of the man pages.
 */
char *ult_src(char *name, char *path)
{
	/* static to save memory */
	static FILE *fp;
	int val;
	char *subdir;
	static char *ult;

	/* must be static */
	static char basename[512];
	static short recurse;
	static size_t len;

	if (recurse == 0){

		/* do some initialization */
		strcpy(basename, path);
		strcat(basename, "/");
		len = strlen(basename);
		if (debug)
			fprintf(stderr, "ult_src: File %s\n", name);
	}
	else if (recurse == 10){	
		fprintf(stderr, 
		  "Warning!: self referencing recursion problem with %s.\n",
		  name);
		return NULL;
	}

	/*
	 * check the 'name' to see if it's a symlink, if so, read it in.
	 * If not, check it for a .so reference.
	 */

	subdir = strrchr(basename, '/')  + 1;

#ifdef TRACE_SYMLINK
	if ( (val = readlink(name, subdir, 512 - (subdir - basename)) ) == -1) { 
#endif
		if ((fp = fopen (name, "r")) == NULL){
			fprintf(stderr, "ultimate source file: ");
			perror(name); 
			return NULL;
		}
		val = fscanf(fp, ".so %512s", basename + len);
		fclose(fp);
#ifdef TRACE_SYMLINK
	} else {
		*(subdir + val) = '\0';
		
		/* deal w/ absolute symlink */

		if (*subdir == '/') 
			relative(path, subdir);
		val = 1;
	}
#endif
	if (val == 1){
	
		/* keep on looking... */

		if (debug)
			fprintf(stderr, "ult_src: points to %s\n", basename);

		recurse++;
		ult = ult_src(basename, path);
		recurse--;

		return ult;
	}
	else
		/* 
		 * we have it. 
		 * The file is either the src (val == 0) 
		 * or is zero in length (val == EOF)
		 * - in which case it is a stray cat place holder.
		 */
		
		return strdup(name);
}

/*
 * Handle the whatis or apropos option.  Cheat by using another program.
 */
void do_extern (char *prog, char *name)
{
	size_t len;
	char *command;
	extern char *pager;

	len = strlen(prog) + strlen(name) + strlen(pager) + 28;

	if ((command = (char *) malloc (len)) == NULL)
		gripe_alloc (len, "command");

	sprintf (command, "PAGER=\"%s\"; export PAGER; %s %s", 
	  pager, prog, name);

	(void) do_system_command_drop_privs (command);

	free (command);
}

short do_manual(char *nextarg)
{
	short status = 0;
	char **mp;

	/* look for user mantrees and check out any databases we may find */
	
	for (mp = manpathlist; *mp != NULL; mp++) {

		/* new definition of not a global mandir */

		if (global_catpath(*mp) == NULL) {

			if (debug) 
				fprintf(stderr, 
				  "\nuser database path - %s\n", *mp);
			
			database = (char *) malloc(strlen(*mp) + sizeof LOCAL_DB);
			strcpy(database, *mp);
			strcat(database, LOCAL_DB);
			drop_effective_privs();
			if (debug) 
				fprintf(stderr, "\neuid now %d, (%s)\n", 
				  geteuid(), getpwuid(geteuid())->pw_name); 
			
			status += find_manual_page(nextarg, mp);
			free(database);
			regain_effective_privs();
			if (debug) 
				fprintf(stderr, "\neuid now %d, (%s)\n", 
				  geteuid(), getpwuid(geteuid())->pw_name); 
			
			if (status && !findall)
				return status;
		}
	} 

	/* Now it's time to consult the main db */
	
	database = GLOBAL_DB;
	status += find_manual_page(nextarg, mp);

	return status;
}

short find_manual_page(char *nextarg, char **mp)
{
	short status = 0;

	/* look for the manual page in which ever database we need to */
	
	status += man (nextarg);

	/*
	 * if we need to find lots or we still haven't found it, look for
	 * new pages that might have arrived
	 *
	 * Do different things depending on the type of db we may have 
	 * to update
	 */

	if (findall || !status ){
		short amount = 0;
		datum key, content;

		key.dptr = KEY;
		key.dsize = sizeof KEY;

		if (*mp == NULL) {

			/* Don't CREATE the global db if it doesn't exist */
			
			while ( (dbf = MYDBM_REOPEN(database)) == NULL) {
				static err;

				if (err == 4) {
					fprintf(stderr,
					  "Could not open %s readonly after 4 attempts.\n",
					  database);
					exit(1);
				} else if (errno == EAGAIN)
					sleep(++err);
				else {
					fprintf(stderr, "Could not open db for reading: ");
					perror(database);
					exit(1);
				}
				exit(1);
			}

			dbver_rd(dbf);

			content = MYDBM_FETCH(dbf, key);

/* If we are using an ndbm implementation, content.dptr will be stepped on
 * when we call testmandirs() as this has it's own MYDBM_FETCH() calls. Thus
 * we must save a copy of the static ndbm content memory area, before we
 * proceed */

#ifdef NDBM
			if (content.dptr)
				content.dptr = strdup(content.dptr);
#endif

			MYDBM_CLOSE(dbf);

			/* check out all of the /usr man trees */

			for (mp = manpathlist; *mp != NULL; mp++) {
 				if (global_catpath(*mp) != NULL) {
 					amount += testmandirs(*mp, 
					  content.dptr == NULL ? 0 : atol(content.dptr));
				}
			}
#ifdef NDBM
			if (content.dptr)
				free(content.dptr);
#endif
		} else {

			/* This is a user db: we might need to CREATE it */
			
			dbf = MYDBM_REOPEN(database);

		/* as this is a user thang, if dbf is null, must not exist */

			if (dbf == NULL || (dbf != NULL && dbver(dbf)) ) {
				/* 
				 * rewrite the db if it either doesn't exist 
				 * or is wrong version.
				 */ 
				if ( (dbf = MYDBM_OPEN(database)) == NULL){
					fprintf(stderr, "%s: find_manual_page: ", prognam);
					perror(database);
					exit(1);
				}
				dbver_wr(dbf);
			}

			content = MYDBM_FETCH(dbf, key);

			MYDBM_CLOSE(dbf);

			amount += testmandirs(*mp, 
			  content.dptr == NULL ? 0 : atol(content.dptr));
		}
#ifdef GDBM
		if (content.dptr)
			MYDBM_FREE(content.dptr);
#endif
		if (amount){
			content.dptr = (char *) malloc(11); /* max long with '\0' */
			sprintf(content.dptr, "%ld", time(NULL));
			content.dsize = strlen(content.dptr) + 1;

                        if ( (dbf = MYDBM_RWOPEN(database)) == NULL){
				fprintf(stderr, "%s: find_manual_page: ",
				prognam);
				perror(database);
				exit(1);
			}

			MYDBM_REPLACE(dbf, key, content);
			MYDBM_CLOSE(dbf);

			free(content.dptr);
			status += man(nextarg);
			fputs(" done\n", stderr);
		} 
	}
	return status;
}
